unit UdmKernel_CadBase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UdmKernel_Base, FMTBcd, DBClient, Provider, DB, SqlExpr;

type
  TdmKernel_CadBase = class(TdmKernel_Base)
    qryCadBase: TSQLQuery;
    qryLstBase: TSQLQuery;
    dspCadBase: TDataSetProvider;
    dspLstBase: TDataSetProvider;
    cdsCadBase: TClientDataSet;
    cdsLstBase: TClientDataSet;
    qryLstColunas: TSQLQuery;
    dspLstColunas: TDataSetProvider;
    cdsLstColunas: TClientDataSet;
    qryLstColunasTLA_TELA: TIntegerField;
    qryLstColunasTLA_NOME: TStringField;
    qryLstColunasTLA_TITULO: TStringField;
    qryLstColunasTLA_CLASSE: TStringField;
    qryLstColunasCLN_COLUNA: TIntegerField;
    qryLstColunasCLN_NOME: TStringField;
    qryLstColunasCLN_SOMA: TStringField;
    qryLstColunasCLN_FILTRA: TStringField;
    qryLstColunasCLN_TAMANHO: TIntegerField;
    qryLstColunasCLN_ORDEM: TIntegerField;
    qryLstColunasCLN_CHAVE: TStringField;
    qryLstColunasSMA_NOME: TStringField;
    cdsLstColunasTLA_TELA: TIntegerField;
    cdsLstColunasTLA_NOME: TStringField;
    cdsLstColunasTLA_TITULO: TStringField;
    cdsLstColunasTLA_CLASSE: TStringField;
    cdsLstColunasCLN_COLUNA: TIntegerField;
    cdsLstColunasCLN_NOME: TStringField;
    cdsLstColunasCLN_SOMA: TStringField;
    cdsLstColunasCLN_FILTRA: TStringField;
    cdsLstColunasCLN_TAMANHO: TIntegerField;
    cdsLstColunasCLN_ORDEM: TIntegerField;
    cdsLstColunasCLN_CHAVE: TStringField;
    cdsLstColunasSMA_NOME: TStringField;
    qryLstColunasSMA_SOMA: TIntegerField;
    cdsLstColunasSMA_SOMA: TIntegerField;
    qryLstColunasCLN_CAPTION: TStringField;
    cdsLstColunasCLN_CAPTION: TStringField;
    procedure cdsCadBaseBeforePost(DataSet: TDataSet);
    procedure cdsCadBaseAfterInsert(DataSet: TDataSet);
    procedure DataModuleCreate(Sender: TObject);
  private

  public
    procedure AfterInsert(ds: Tdataset; str_tabela, str_campochave: string); virtual;
    procedure BeforePost(ds: Tdataset; str_tabela, str_campochave: string); virtual;
  end;

var
  dmKernel_CadBase: TdmKernel_CadBase;

implementation

uses UKernel_VariaveisPublic, UKernel_DB, UdmPrincipal;

{$R *.dfm}

procedure TdmKernel_CadBase.AfterInsert(ds: Tdataset; str_tabela, str_campochave: string);
begin
  { Recebe o proximo ID da tabela sempre que for novo registro }
  ds.FieldByName(str_campochave).value:= Incrementa(str_tabela,str_campochave);
end;

procedure TdmKernel_CadBase.cdsCadBaseAfterInsert(DataSet: TDataSet);
begin
  inherited;
  AfterInsert(DataSet,Kernel_Cadastro.str_Tabela,Kernel_Cadastro.str_CampoChave);
end;

procedure TdmKernel_CadBase.cdsCadBaseBeforePost(DataSet: TDataSet);
begin
  inherited;
  BeforePost(DataSet,Kernel_Cadastro.str_Tabela,Kernel_Cadastro.str_CampoChave);
end;

procedure TdmKernel_CadBase.DataModuleCreate(Sender: TObject);
begin
  inherited;
  {Define qual e o clientdataset de cadastro}
  DatasetCadastro    := cdsCadBase;
  DatasetqryCadastro := qryCadBase;
  DatasetColunas     := cdsLstColunas;
  DatasetListagem    := cdsLstBase;
end;

procedure TdmKernel_CadBase.BeforePost(ds: Tdataset; str_tabela, str_campochave: string);
begin
  {Se for insercao Recebe o proximo ID da tabela }
  if ds.State in [dsinsert] then
  begin
    ds.FieldByName(str_campochave).value:= Incrementa(str_tabela,str_campochave);
  end;
end;

end.
