unit UfrmKernel_Login;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, DBTables, ComCtrls,
  jpeg, adodb, JvExControls, JvXPCore, JvXPButtons, DBCtrls, 
  JvExComCtrls, JvDateTimePicker, UfrmKernel_Base, SqlExpr, ActnList, ImgList;

type
  TfrmKernel_Login = class(TfrmKernel_Base)
    statBase: TStatusBar;
    lbldata: TLabel;
    pnlFudo: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    imgSenha: TImage;
    lblAplicativo: TLabel;
    imgUsuario: TImage;
    Label3: TLabel;
    imgLogo: TImage;
    edtLoginUsu: TEdit;
    edtSenhaUsu: TEdit;
    Panel2: TPanel;
    btnConfirmar: TJvXPButton;
    btnSair: TJvXPButton;
    tmrTempo: TTimer;
    actlstLogin: TActionList;
    actConfirmar: TAction;
    actSair: TAction;
    ilLogin: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure edtPSWKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure tmrTempoTimer(Sender: TObject);
    procedure actSairExecute(Sender: TObject);
    procedure actConfirmarExecute(Sender: TObject);
    procedure edtLoginUsuKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
     procedure AntesValidaUsuario(); virtual;
     procedure ValidaUsuario(const str_usuario, str_senha: string); virtual;
     procedure DepoisValidaUsuario(); virtual;

     {Verifica os campos Obrigatorios}
     procedure VerificaDados;
     {Retorna a quantidade de tentativas disponiveis para tentar logar}
     function QuantidadeTentativas: Integer;
  public
    Tentativas, LimiteTentativas : Integer; // Numero de Tentativa para logar
  end;

var
  frmKernel_Login: TfrmKernel_Login;

implementation

uses UdmPrincipal, DB, UfrmKernel_Mensagem, UKernel_Mensagem, UKernel_DATA, UKernel_Security,
  UKernel_VariaveisPublic, UKernel_DB,  UKernel_sysutils, UdmKernel_Acesso,
  UclKernel_Login, UKernel_Mensagem_Usuario;

{$R *.dfm}

{ TfrmKernel_Login }

procedure TfrmKernel_Login.validaUsuario(const str_usuario, str_senha: string);
begin
  {Acontece antes de tentar logar}
  AntesValidaUsuario;

  with dmPrincipal, qryKernel_Gerenerica do
  begin
    if Tentativas < LimiteTentativas then
      begin
        inc(Tentativas);
        sqlConnection:= FConexao; {: componente de conexo}
        close;
        sql.Clear;
        {Seleciona os campos na tabela onde o usuario e senha sejam igual
        aos passados nos edits.}
        sql.Add (' SELECT USU_USUARIO, USU_NOME, USU_STS_ADMIN ' +
                   '  FROM USU_USUARIO ' +
                   ' WHERE USU_LOGIN = ' + QuotedStr(str_usuario) +
                   '   AND USU_SENHA = ' + QuotedStr(str_senha));
        Open;

        if not IsEmpty then // Se no retornar vazio
          Begin
            Kernel_Login.int_codusu        :=  Fields[0].AsInteger;
            Kernel_Login.str_nomeusu       :=  Fields[1].AsString;
            Kernel_Login.str_adminusu      :=  Fields[2].AsString;

            {Acontece depois que o usuario logar}
            DepoisValidaUsuario;

            ModalResult := mrOk;
          End
         else
          Begin
            TfrmKernel_Mensagem.Mensagem('Usurio ou Senha Invlidos ' +#13#10+
                                   ' - Tentativa '+ IntToStr(Tentativas) + ' de ' +  IntToStr(LimiteTentativas) ,'E',[mbOK]);
            statBase.Panels[3].Text := IntToStr(Tentativas);
            edtLoginUsu.SetFocus;
          end;
      end
     else
      begin
        TfrmKernel_Mensagem.Mensagem('Limite de Tentativas Execido ' +#13#10+
                             ' - Em caso de Dvida entre em Contato ' +#13#10+
                             ' - Administrador do Sistema ' ,'E',[mbOK]);
        Application.Terminate; // Termina Aplicao
      end;
  end;
end;

procedure TfrmKernel_Login.VerificaDados;
begin
  {Valida o Login}
  if edtloginusu.Text = '' then
  Begin
    TfrmKernel_Mensagem.Mensagem(Kernel_Informe_LoginValido,'E',[mbOK]);
    edtloginusu.SetFocus;
    exit;
  end;

  {Valida a senha}
  if edtsenhausu.Text = '' then
  Begin
    TfrmKernel_Mensagem.Mensagem(Kernel_Informe_SenhaValida ,'E',[mbOK]);
    edtsenhausu.SetFocus;
    exit;
  end;

  {Se o Login e senha sejam validos tenta acessar}
  validaUsuario(AnsiUpperCase(trim(edtloginusu.Text)), trim(edtsenhausu.Text));
end;

procedure TfrmKernel_Login.edtPSWKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key= vk_return then VerificaDados;
end;

function TfrmKernel_Login.QuantidadeTentativas: Integer;
var
  Qry:TsqlQuery;
begin
  qry := TsqlQuery.Create(nil); {: cria uma instncia do objeto}
  try
    with Qry do
    begin
      sqlConnection:= FConexao; {: componente de conexo}
      close;
      SQL.Clear;
      SQL.Add('SELECT PMU_QTD_TENTATIVAS FROM USU_PARAMETRO');
      Open;

      result := FieldByName('PMU_QTD_TENTATIVAS').asinteger;
    end;
  finally
    FreeAndNil(Qry);  {: libera o objeto da memria}
  end;
end;

procedure TfrmKernel_Login.tmrTempoTimer(Sender: TObject);
begin
  lblData.Caption :=  FormatDateTime('dddd,dd" de "mmmm"',Data_Server)+'  '+(FormatDateTime('hh:mm',Data_Server));
end;

procedure TfrmKernel_Login.FormCreate(Sender: TObject);
begin
  // Mostra a Quantidade de Tentativas
  statBase.Panels[1].Text := IntToStr(QuantidadeTentativas);
  Tentativas              := 0;
  LimiteTentativas        := QuantidadeTentativas;
  statBase.Panels[3].Text := IntToStr(LimiteTentativas);
end;

procedure TfrmKernel_Login.FormShow(Sender: TObject);
begin
  {Carega Imagem que ser mostrada no Timage}
  MostraFotoImage('LogoSoftHouse','LogoSoftHouse',imgLogo);

  // Receber a data do computador
  lblData.Caption :=  FormatDateTime('dddd,dd" de "mmmm"',date)+'  '+(FormatDateTime('hh:mm',date));

  kernel_RefreshCds(dmKernel_Acesso.cdsLstEmp);

  edtloginusu.SetFocus;
end;

procedure TfrmKernel_Login.actSairExecute(Sender: TObject);
begin
  inherited;
  {Fecha a aplicao}
  Application.Terminate;
end;

procedure TfrmKernel_Login.actConfirmarExecute(Sender: TObject);
begin
  inherited;
  VerificaDados;
end;

procedure TfrmKernel_Login.AntesValidaUsuario;
begin
  // metodo implementado no filho
end;

procedure TfrmKernel_Login.DepoisValidaUsuario;
begin
  // metodo implementado no filho
end;

procedure TfrmKernel_Login.edtLoginUsuKeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  {: troca ENTER por TAB}
  if key = #13 then
    begin
      Perform (CM_DialogKey, VK_TAB, 0);
      key:=#0;
    end
end;

end.
