unit UfrmKernel_LstBase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, DB, DBCtrls, Grids, DBGrids, JvExDBGrids,
  JvDBGrid, ComCtrls, StdCtrls, JvComponentBase,AppEvnts,
  ImgList, Ufrmkernel_Base, DBClient, pngimage, JvExControls, JvXPCore, JvXPButtons,
  Buttons, ActnList, RzButton, RzPanel, menus, cxStyles, cxCustomData,
  cxGraphics, cxFilter, cxData, cxDataStorage, cxEdit, cxDBData, cxGridLevel,
  cxClasses, cxControls, cxGridCustomView, cxGridCustomTableView,
  cxGridTableView, cxGridDBTableView, cxGrid, dxGDIPlusClasses, cxFilterControl,
  dxSkinsCore, dxSkinBlack, dxSkinBlue, dxSkinCaramel, dxSkinCoffee,
  dxSkinDarkSide, dxSkinGlassOceans, dxSkiniMaginary, dxSkinLilian,
  dxSkinLiquidSky, dxSkinLondonLiquidSky, dxSkinMcSkin, dxSkinMoneyTwins,
  dxSkinOffice2007Black, dxSkinOffice2007Blue, dxSkinOffice2007Green,
  dxSkinOffice2007Pink, dxSkinOffice2007Silver, dxSkinPumpkin, dxSkinSilver,
  dxSkinStardust, dxSkinSummer2008, dxSkinsDefaultPainters, dxSkinValentine,
  dxSkinXmas2008Blue, dxSkinscxPCPainter;

type
  TfrmKernel_LstBase = class(TfrmKernel_Base)
    statBase: TStatusBar;
    pnlBottom: TPanel;
    aplctnvntsBase: TApplicationEvents;
    imgLBase: TImageList;
    dsBase: TDataSource;
    lblAtalhos: TLabel;
    pnlRelBase: TPanel;
    pnlTitulo: TPanel;
    lblTitulo: TLabel;
    lblSubtitulo: TLabel;
    ilLstBase: TImageList;
    actlstCadBase: TActionList;
    actNovo: TAction;
    actAlterar: TAction;
    actCancelar: TAction;
    actSalvar: TAction;
    actFechar: TAction;
    actAbrir: TAction;
    actImprimir: TAction;
    actExcluir: TAction;
    actFiltrar: TAction;
    actConsultar: TAction;
    imgListaBase: TImage;
    tlbrCadBase: TRzToolbar;
    btnNovo: TRzToolButton;
    btnAlterar: TRzToolButton;
    btnExcluir: TRzToolButton;
    btnImprimir: TRzToolButton;
    RzSpacer2: TRzSpacer;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    cxGrid1: TcxGrid;
    cxGrid1DBTableView1: TcxGridDBTableView;
    cxGrid1Level1: TcxGridLevel;
    cxspyBase: TcxStyleRepository;
    GridTableViewStyleSheetUserFormat2: TcxGridTableViewStyleSheet;
    cxStyle1: TcxStyle;
    cxStyle2: TcxStyle;
    cxStyle3: TcxStyle;
    cxStyle4: TcxStyle;
    cxStyle5: TcxStyle;
    cxStyle6: TcxStyle;
    cxStyle7: TcxStyle;
    cxStyle8: TcxStyle;
    cxStyle9: TcxStyle;
    cxStyle10: TcxStyle;
    cxStyle11: TcxStyle;
    lblTipoRel: TLabel;
    cbbRelBase: TComboBox;
    btnFiltrar: TRzToolButton;
    RzSpacer3: TRzSpacer;
    actlstPropria: TActionList;
    ilPropria: TImageList;
    btnFechar: TSpeedButton;
    RzSpacer1: TRzSpacer;
    procedure btnLstTodosClick(Sender: TObject);
    procedure btnFiltrarClick(Sender: TObject);
    procedure dbgBaseKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnFecharClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure actNovoExecute(Sender: TObject);
    procedure actAlterarExecute(Sender: TObject);
    procedure actExcluirExecute(Sender: TObject);
    procedure actConsultarExecute(Sender: TObject);
    procedure actImprimirExecute(Sender: TObject);
    procedure actFecharExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actFiltrarExecute(Sender: TObject);
  private

  public
     procedure PermissoesForm; virtual;
       
    {Executa antes de executar o Excluir registro}
    procedure AntesExcluirRegistro; virtual;
    {Execura o metodo Excluir Registro}
    procedure ExcluirRegistro; virtual;
    {Executa Todo o processo de antes Excluir depois}
    procedure Executa_ExcluirRegistro; virtual;
    {Executa Depois de executar o Excluir registro}
    procedure DepoisExcluirRegistro; virtual;

    {Executa antes de executar o novo registro}
    procedure AntesNovoRegistro; virtual;
    {Execura o metodo Novo Registro}
    procedure NovoRegistro; virtual;
    {Executa Todo o processo de antes novo depois}    
    procedure Executa_NovoRegistro; virtual;
    {Executa Depois de executar o novo registro}    
    procedure DepoisNovoRegistro; virtual;

    {Executa antes de executar o Alterar registro}
    procedure AntesAlterarRegistro; virtual;
    {Execura o metodo Alterar Registro}
    procedure AlterarRegistro; virtual;
    {Executa Todo o processo de antes Alterar depois}
    procedure Executa_AlterarRegistro; virtual;
    {Executa Depois de executar o Alterar registro}
    procedure DepoisAlterarRegistro; virtual;

    {Executa antes de executar o Fechar}
    procedure AntesFechar; virtual;
    {Execura o metodo Fechar}    
    procedure Fechar; virtual;
    {Executa Todo o processo de antes Cancelar depois}
    procedure Executa_Fechar; virtual;
    {Executa Depois de executar o Fechar}
    procedure DepoisFechar; virtual;

    {Executa antes de executar o Imprimir registro}
    procedure AntesImprimirRegistro; virtual;
    {Execura o metodo Imprimir Registro}
    procedure ImprimirRegistro(int_codrel: Integer); virtual;
    {Executa Todo o processo de antes Imprimir depois}
    procedure Executa_ImprimirRegistro; virtual;
    {Executa Depois de executar o Imprimir registro}
    procedure DepoisImprimirRegistro; virtual;

    procedure ExecutaPesquisaBase; virtual;
    procedure PesquisaBase; virtual;

    function AnalisaPodePesquisa(): Boolean; virtual;

    procedure CaregaColunas;

  end;

var
  frmKernel_LstBase: TfrmKernel_LstBase;

  ListaField: Array of Integer;
  Pacotes: Integer;

implementation

uses Ukernel_sysutils, Ukernel_Mensagem, UdmKernelPrincipal, UKernel_VariaveisPublic,
  Ukernel_DB, Ufrmkernel_Mensagem, Udmkernel_Acesso, UKernel_Grid,
  UdmKernel_CadBase, UfrmKernel_Aguarde, UKernel_Exception, UfrmKernel_Filtro;

{$R *.dfm}

procedure TfrmKernel_LstBase.actAlterarExecute(Sender: TObject);
begin
  inherited;
  if DsBase.DataSet.IsEmpty then
  begin
    TfrmKernel_Mensagem.Mensagem(Kernel_Aviso_TabelaVazia, 'I', [mbOk]);
    Abort;
  end;

  Executa_AlterarRegistro;
end;

procedure TfrmKernel_LstBase.actConsultarExecute(Sender: TObject);
begin
  inherited;
  ExecutaPesquisaBase;
end;

procedure TfrmKernel_LstBase.actExcluirExecute(Sender: TObject);
begin
  inherited;
  if DsBase.DataSet.IsEmpty then
  begin
    TfrmKernel_Mensagem.Mensagem(Kernel_Aviso_TabelaVazia, 'I', [mbOk]);
    Abort;
  end;

  Executa_ExcluirRegistro;
end;

procedure TfrmKernel_LstBase.actFecharExecute(Sender: TObject);
begin
  inherited;
  Executa_Fechar;
end;

procedure TfrmKernel_LstBase.actFiltrarExecute(Sender: TObject);
begin
  inherited;
   application.CreateForm(TfrmKernel_Filtro,frmKernel_Filtro);
   try
     frmKernel_Filtro.fclFiltro.LinkComponent := cxGrid1DBTableView1;
     frmKernel_Filtro.ShowModal;
   finally
     cxGrid1DBTableView1.DataController.Filter.Active := True;

     FreeAndNil(frmKernel_Filtro);
   end;
end;

procedure TfrmKernel_LstBase.actImprimirExecute(Sender: TObject);
begin
  inherited;
  if DsBase.DataSet.IsEmpty then
  begin
    TfrmKernel_Mensagem.Mensagem(Kernel_Aviso_TabelaVazia, 'I', [mbOk]);
    Abort;
  end;

  Executa_ImprimirRegistro;
end;

procedure TfrmKernel_LstBase.actNovoExecute(Sender: TObject);
begin
  inherited;
  Executa_NovoRegistro;
end;

procedure TfrmKernel_LstBase.AlterarRegistro;
 var
 obj: TForm;
 frmclass: TFormClass;
begin
  // Localiza classe
  frmclass := TFormClass(FindClass(strclass));
  try
    Bookmark := dsBase.dataset.GetBookmark;
    // Instancia formulario
    obj := frmclass.Create(self);
    // Executa antes de alterar o registro
    AntesAlterarRegistro;

    // Mostra para o usuario
    obj.ShowModal;
  finally
    if obj.ModalResult = mrok then
      begin
        // Executa depois de alterar o registro
        DepoisAlterarRegistro;

        ExecutaPesquisaBase;

        // Volta o foco para o registro alterado depois de atualizar os dados
        dsBase.DataSet.GotoBookmark(Bookmark);
      end;

    // Libera Instancia da memoria
    FreeAndNil(obj);
  end;
end;

function TfrmKernel_LstBase.AnalisaPodePesquisa: Boolean;
begin

end;

procedure TfrmKernel_LstBase.AntesAlterarRegistro;
begin
  {DatasetCadastro deve ser informado na criao do form de listagem}
  with DatasetCadastro do
  begin
    Close;
    Params[0].Value := DsBase.DataSet.FieldByName(Kernel_Cadastro.str_CampoChave).value;
    Open;

    edit;
  end;
end;

procedure TfrmKernel_LstBase.AntesExcluirRegistro;
begin
  // Pega o Ponteiro do Registro Atual
  Bookmark := dsBase.dataset.GetBookmark;

  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.AntesFechar;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.AntesImprimirRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.AntesNovoRegistro;
begin
  {DatasetCadastro deve ser informado na criao do form de listagem}
  with DatasetCadastro do
  begin
    Close;
    Params[0].Value := null;
    Open;

    Append;
  end;
end;

procedure TfrmKernel_LstBase.btnFecharClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmKernel_LstBase.btnFiltrarClick(Sender: TObject);
begin
  inherited;
  PesquisaBase;
end;

procedure TfrmKernel_LstBase.btnLstTodosClick(Sender: TObject);
begin
  inherited;
  PesquisaBase;
end;

procedure TfrmKernel_LstBase.CaregaColunas;
var
  int_coluna: Integer;
begin
  with DatasetColunas do
  begin
    close;
    Params[0].Value := Kernel_Cadastro.str_Tabela;
    Open;

    if not IsEmpty then
      begin
        First;

        while not eof do
        begin
          {Ordem que a coluna vai ficar no grid}
          int_coluna := DatasetColunas.FieldByName('CLN_ORDEM').Value;

          {Cria a nova coluna}
          cxGrid1DBTableView1.CreateColumn;

          // field
          cxGrid1DBTableView1.Columns[int_coluna].DataBinding.FieldName := DatasetColunas.FieldByName('CLN_NOME').Value;
          // Caption
          cxGrid1DBTableView1.Columns[int_coluna].Caption :=  DatasetColunas.FieldByName('CLN_CAPTION').Value;
          // tamanho da coluna
          cxGrid1DBTableView1.Columns[int_coluna].Width :=   DatasetColunas.FieldByName('CLN_TAMANHO').Value;

          {Se o usuario pode ou nao filtrar valores dessa coluna}
          if  DatasetColunas.FieldByName('CLN_FILTRA').Value = 'T' then
            cxGrid1DBTableView1.Columns[int_coluna].Options.Filtering := True
           else
            cxGrid1DBTableView1.Columns[int_coluna].Options.Filtering := False;

          {Se o campo vai fazer algum tipo de sumarizao}
          if DatasetColunas.FieldByName('CLN_SOMA').Value = 'T' then
            begin
              case  DatasetColunas.FieldByName('').Value of
                1 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := skCount;
                2 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := SkSum;
                3 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := skMax;
                4 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := skMin;
                5 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := skNone;
                6 : cxGrid1DBTableView1.Columns[int_coluna].Summary.FooterKind := skAverage;
              end;
            end;

          Next;
        end;
      end;
  end;
end;

procedure TfrmKernel_LstBase.NovoRegistro;
 var
 obj: TForm;
 frmclass: TFormClass;
begin
  // Localiza classe
  frmclass := TFormClass(FindClass(strclass));
  try
    Bookmark := dsBase.DataSet.GetBookmark;
    // Instancia formulario
    obj := frmclass.Create(self);
    // Executa antes de novo o registro
    AntesNovoRegistro;

    // Mostra para o usuario
    obj.ShowModal;
  finally
    if obj.ModalResult = mrok then
      begin
        // Executa depois de novo o registro
        DepoisNovoRegistro;

        ExecutaPesquisaBase;

        // Volta o foco para o registro alterado depois de atualizar os dados
        dsBase.DataSet.GotoBookmark(Bookmark);
      end;

    // Libera Instancia da memoria
    FreeAndNil(obj);
  end;
end;

procedure TfrmKernel_LstBase.dbgBaseKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  // Impede o uso do ctrl + del
  if (Shift = [ssCtrl]) and (Key = 46) Then
  KEY := 0;

  if actExcluir.Enabled = True then
  begin
    if Key= VK_DELETE then
      Executa_ExcluirRegistro;
  end;

end;

procedure TfrmKernel_LstBase.DepoisAlterarRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.DepoisExcluirRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.DepoisFechar;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.DepoisImprimirRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.DepoisNovoRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.PermissoesForm;
var   MyMenu: TMenuItem;
begin
inherited;
  // Se no for administrador verifica permisses
  if not (Kernel_Login.str_adminusu = 'T') then
  Begin
    // permisoes por perfil
    with dmKernel_Acesso, cDsDireitoAcesso do
    begin
      Close;
      Params.ParamByName('CODUSU').value :=  Kernel_Login.int_codusu;
      Params.ParamByName('CODMENU').value := kernel_CodMenu ;
      Open;

      // Habilita Botoes de Controle Conforme Permisao
      actNovo.Enabled := FieldByName('actNOVO').AsString = 'T';
      actAlterar.Enabled := FieldByName('actalterar').AsString = 'T';
      actExcluir.Enabled := FieldByName('actapagar').AsString = 'T';

      statBase.Panels[1].Text := 'Direitos de Acesso:';
      if FieldByName('actNOVO').AsString = 'T' then
        statBase.Panels[1].Text := statBase.Panels[1].Text + ' Novo - ';

      if FieldByName('actalterar').AsString = 'T' then
        statBase.Panels[1].Text := statBase.Panels[1].Text + ' Alterar - ';

      if FieldByName('actapagar').AsString = 'T' then
        statBase.Panels[1].Text := statBase.Panels[1].Text + ' Apagar';
    end;

    // permisoes por usuario
    with dmKernel_Acesso, cDsDireitoAcessoUsuario do
    begin
      Close;
      Params.ParamByName('CODUSU').value :=  Kernel_Login.int_codusu;
      Params.ParamByName('CODMENU').value := kernel_CodMenu ;
      Open;

      if not IsEmpty then
      begin
        // Habilita Botoes de Controle Conforme Permisao
        actNovo.Enabled := FieldByName('actNOVO').AsString = 'T';
        actAlterar.Enabled := FieldByName('actalterar').AsString = 'T';
        actExcluir.Enabled := FieldByName('actapagar').AsString = 'T';

        statBase.Panels[1].Text := 'Direitos de Acesso:';
        if FieldByName('actNOVO').AsString = 'T' then
          statBase.Panels[1].Text := statBase.Panels[1].Text + ' Novo - ';

        if FieldByName('actalterar').AsString = 'T' then
          statBase.Panels[1].Text := statBase.Panels[1].Text + ' Alterar - ';

        if FieldByName('actapagar').AsString = 'T' then
          statBase.Panels[1].Text := statBase.Panels[1].Text + ' Apagar';
      end;
    end;
  end;
end;

procedure TfrmKernel_LstBase.PesquisaBase;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.ExcluirRegistro;
begin
  // Sobrescrever no form filho
end;

procedure TfrmKernel_LstBase.ExecutaPesquisaBase;
begin
  if not Assigned(frmKernel_Aguarde) then
    Application.CreateForm(TfrmKernel_Aguarde,frmKernel_Aguarde);
  try
    application.ProcessMessages;

    frmKernel_Aguarde.Show;
    frmKernel_Aguarde.Release;
    frmKernel_Aguarde.Refresh;

    PesquisaBase;

    application.ProcessMessages;
  finally
    if Assigned(frmKernel_Aguarde) then
      FreeAndNil(frmKernel_Aguarde);
  end;
end;

procedure TfrmKernel_LstBase.Executa_AlterarRegistro;
begin
  AlterarRegistro;
end;

procedure TfrmKernel_LstBase.Executa_ExcluirRegistro;
begin
  // Chama o Evento Antes de Excluir
  AntesExcluirRegistro;

  if Kernel_Confirmacao_acao(Kernel_Confirmacao_Apaga_Registro,'D') then
    begin
      {Apaga registro atual}
      try
        try
          Kernel_Apaga_Registro(Kernel_Cadastro.str_Tabela,Kernel_Cadastro.str_CampoChave,
            DatasetListagem.FieldByName(Kernel_Cadastro.str_CampoChave).Value );

          // Chama o Evento Apos Excluir
          DepoisExcluirRegistro;

          FrmKernel_Mensagem.Mensagem(Kernel_Aviso_Exclusao,'I',[mbOk]);

          ExecutaPesquisaBase;
        except
          // Volta para o ponteiro atual
          dsBase.DataSet.GotoBookmark(Bookmark);

          raise Livre_Mensagem_Global.CreateFmt(Kernel_Erro_FalhaInesperada + ' no registro %s . ',
            ['('+ DatasetListagem.FieldByName(Kernel_Cadastro.str_CampoChave).Value +')']);
        end;
      finally
        Bookmark := nil;
      end;
    end;
end;

procedure TfrmKernel_LstBase.Executa_Fechar;
begin
  AntesFechar;
  Fechar;
  DepoisFechar;
end;

procedure TfrmKernel_LstBase.Executa_ImprimirRegistro;
begin
  AntesImprimirRegistro;
  ImprimirRegistro(cbbRelBase.ItemIndex);
  DepoisImprimirRegistro;
end;

procedure TfrmKernel_LstBase.Executa_NovoRegistro;
begin
  NovoRegistro;
end;

procedure TfrmKernel_LstBase.Fechar;
begin
  close;
end;

procedure TfrmKernel_LstBase.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  DsBase.DataSet.Close;
end;

procedure TfrmKernel_LstBase.FormCreate(Sender: TObject);
begin
  inherited;
  kernel_str_form := 'Listagem de '+ kernel_srt_nmformbase;
  lblTitulo.Caption := 'Listagem de '+ kernel_srt_nmformbase;
  lblSubtitulo.Caption := 'Gerenciamento de '+ kernel_srt_nmformbase;

  {Verifica as permissoes do usuario logado}
 // PermissoesForm;
end;

procedure TfrmKernel_LstBase.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if actNovo.Enabled = True then
  begin
    if Key= VK_Insert then Executa_NovoRegistro;
  end;

  if actAlterar.Enabled = True then
  begin
    if Key= VK_F2 then Executa_AlterarRegistro;
  end;

  if Key= VK_F5 then Executa_ImprimirRegistro;

  if Key= VK_F6 then PesquisaBase;
end;

procedure TfrmKernel_LstBase.FormShow(Sender: TObject);
begin
  inherited;
  {Datasource recebe o seu dataset}
  dsBase.DataSet := DatasetListagem;
  // Carega Colunas do grid
  CaregaColunas;
end;

procedure TfrmKernel_LstBase.ImprimirRegistro(int_codrel: Integer);
begin
  // aqui sera codificado no filho
end;

procedure TfrmKernel_LstBase.Label3Click(Sender: TObject);
begin
  inherited;
  DsBase.DataSet.Filtered := False;
end;


end.
