unit Ukernel_Config;

interface

uses IniFiles, Forms, SysUtils, Controls;

  // Gravar Texto em Arquivo de Configurao
  procedure SalvaTexto(strSessao, strChave, strTexto : String);
  // Gravar Inteiro em Arquivo de Configurao
  procedure SalvaInteiro(strSessao, strChave : String; const intValor : Integer);
  // Gravar Booleano em Arquivo de COnfigurao
  procedure SalvaBooleano(strSessao,strChave : String; const bolValor : Boolean);
  // Gravar Data em Arquivo de COnfigurao
  procedure SalvaData(strSessao,strChave : String; const datValor : TDate);
  // Gravar Hora em Arquivo de COnfigurao
  procedure SalvaHora(strSessao,strChave : String; const datValor : TTime);
  // Gravar Data e Hora em Arquivo de COnfigurao
  procedure SalvaDataHora(strSessao,strChave : String; const datValor : TDateTime);
  // Gravar Real em Arquivo de COnfigurao
  procedure SalvaReal(strSessao,strChave : String; const fltValor : Real);
  // Ler Texto do Arquivo de Configurao
  function LerTexto(strSessao,StrChave : String) : String;
  // Ler Texto do Arquivo de Configurao
  function LerInteiro(strSessao,StrChave : String) : INteger;
  // Ler Texto do Arquivo de Configurao
  function LerBooleano(strSessao,StrChave : String) : boolean;
  // Ler Texto do Arquivo de Configurao
  function LerData(strSessao,StrChave : String) : TDate;
  // Ler Texto do Arquivo de Configurao
  function LerHora(strSessao,StrChave : String) : TTime;
  // Ler Texto do Arquivo de Configurao
  function LerDataHora(strSessao,StrChave : String) : TDateTime;
  // Ler Texto do Arquivo de Configurao
  function LerReal(strSessao,StrChave : String) : Real;
  // Retorna o Path onde o Programa Principal est
  function path : string;

implementation

uses DateUtils, UKernel_Mensagem;

//==============================================================================
function path : string;
begin
   result := ExtractFilePath(Application.ExeName) + Kernel_arquivo_ConexaoDB;
end;

//==============================================================================
procedure SalvaTexto(strSessao, strChave, strTexto : String);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
    Try
      WriteString(strSessao, strChave, strTexto);
    Finally
      Free;
    end;
end;
//==============================================================================
procedure SalvaInteiro(strSessao, strChave : String; const intValor : Integer);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteInteger(strSessao, strChave, intValor);
  Finally
    Free;
  end;
end;
//==============================================================================
procedure SalvaBooleano(strSessao,strChave : String; const bolValor : Boolean);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteBool(strSessao,strChave,bolValor);
  Finally
    Free;
  end;
end;

//==============================================================================
procedure SalvaData(strSessao,strChave : String; const datValor : TDate);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteDate(strSessao,strChave,datValor);
  Finally
    Free;
  end;
end;

//==============================================================================
procedure SalvaHora(strSessao,strChave : String; const datValor : TTime);

begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteTime(strSessao,strChave,datValor);
  Finally
    Free;
  end;
end;

//==============================================================================
procedure SalvaDataHora(strSessao,strChave : String; const datValor : TDateTime);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteDateTime(strSessao,strChave,datValor);
  Finally
    Free;
  end;
end;

//==============================================================================
procedure SalvaReal(strSessao,strChave : String; const fltValor : Real);
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    WriteFloat(strSessao,strChave,fltValor);
  Finally
    Free;
  end;
end;

//==============================================================================
function LerTexto(strSessao,StrChave : String) : String;
var
  strvalor : String;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    strValor := ReadString(strSessao,strChave, strValor);
  Finally
    Free;
  end;
  result := strValor;
end;

//==============================================================================
function LerInteiro(strSessao,StrChave : String) : INteger;
var
  intValor : Integer;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    intValor := ReadInteger(strSessao,strChave,0);
  Finally
    Free;
  end;
  result := intValor;
end;
//==============================================================================
function LerBooleano(strSessao,StrChave : String) : boolean;
var
  bolResult : boolean;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    bolResult := ReadBool(strSessao,strChave, false);
  Finally
    Free;
  end;
  result := bolResult;
end;
//==============================================================================
function LerData(strSessao,StrChave : String) : TDate;
var
  datData : TDate;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    datData := ReadDate(strSessao,strChave, EncodeDate(00,00,00));
  Finally
    Free;
  end;
  result := datData;
end;
//==============================================================================
function LerHora(strSessao,StrChave : String) : TTime;
var
  datHora : TTime;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    datHora := ReadTime(strSessao,strChave, EncodeTime(00,00,00,00));
  Finally
    Free;
  end;
  result := datHora;
end;
//==============================================================================
function LerDataHora(strSessao,StrChave : String) : TDateTime;
var
  datDataHora : TDateTime;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    datDataHora :=  ReadDateTime(strSessao,strChave, EncodeDateTime(00,00,00,00,00,00,00));
  Finally
    Free;
  end;
  result := datDataHora;
end;
//==============================================================================
function LerReal(strSessao,StrChave : String) : Real;
var
  fltvalor : Real;
begin
  // Cria Arquivo INI na pasta do Aplicativo
  with TIniFile.Create(path) do
  Try
    fltvalor := ReadFloat(strSessao,strChave, 0);
  Finally
    Free;
  end;
  result := fltValor;
end;
//==============================================================================
end.
