unit uCadPessoa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCad, StdCtrls, Buttons, ExtCtrls, DBCtrls, DB, Mask,
  ExtDlgs, JPEG, Videocap, ClipBrd;

type
  TfrmCadPessoa = class(TfrmModeloCad)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    DBEdit5: TDBEdit;
    Label6: TLabel;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    Label8: TLabel;
    DBEdit8: TDBEdit;
    DBEdit9: TDBEdit;
    Label10: TLabel;
    DBEdit10: TDBEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    DBMemo1: TDBMemo;
    DBComboBox1: TDBComboBox;
    opd: TOpenPictureDialog;
    pFoto: TPanel;
    bCapturar: TBitBtn;
    bSelecionar: TBitBtn;
    bLimpar: TBitBtn;
    img: TImage;
    VideoCap1: TVideoCap;
    procedure DBMemo1KeyPress(Sender: TObject; var Key: Char);
    procedure btGravarClick(Sender: TObject);
    procedure btCancelarClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DBImage1DblClick(Sender: TObject);
    procedure bSelecionarClick(Sender: TObject);
    procedure bLimparClick(Sender: TObject);
    procedure bCapturarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCadPessoa: TfrmCadPessoa;

implementation

uses uDM, uLib;

{$R *.dfm}

procedure TfrmCadPessoa.bCapturarClick(Sender: TObject);
var
  BMP: TBitMap;
  JPG: TJpegImage;
  arq_foto: String;
begin
  inherited;
  arq_foto := ExtractFilePath(Application.ExeName) + 'foto.jpg';

  if bCapturar.Caption = 'Cap&turar' then
  begin
    VideoCap1.DriverIndex := 0;
    try
      VideoCap1.Visible := True;
      VideoCap1.VideoPreview := True;
      bCapturar.Caption := '&Tirar Foto';
    except
      VideoCap1.VideoPreview := False;
      VideoCap1.Visible := False;
      bCapturar.Caption := 'Cap&turar';
      Alerta('No foi possvel inicializar a cmera!');
    end
  end
  else
  begin
    VideoCap1.SaveToClipboard;
    BMP := TBitMap.Create;
    try
      BMP.LoadFromClipboardFormat(cf_BitMap,ClipBoard.GetAsHandle(cf_Bitmap),0);
      JPG := TJpegImage.Create;
      try
        JPG.Assign(BMP);
        JPG.SaveToFile(arq_foto);
        img.Picture.LoadFromFile(arq_foto);
        dm.cdsPessoaFOTO.LoadFromFile(arq_foto);
      finally
        JPG.Free;
      end;
    finally
      BMP.Free;
    end;
    Clipboard.Clear;
    VideoCap1.VideoPreview := False;
    VideoCap1.Visible := False;
    bCapturar.Caption := 'Cap&turar';
  end;
end;

procedure TfrmCadPessoa.bLimparClick(Sender: TObject);
begin
  inherited;
  with dm.cdsPessoa do
    if not (State in dsEditModes) then
      Edit;
  img.Picture.Assign(nil);
  dm.cdsPessoaFOTO.Clear;
  pFoto.Caption := 'Sem Foto';
end;

procedure TfrmCadPessoa.bSelecionarClick(Sender: TObject);
begin
  inherited;
  if opd.Execute then
  begin
    with dm.cdsPessoa do
      if not (State in dsEditModes) then
        Edit;
    img.Picture.LoadFromFile(opd.FileName);
    dm.cdsPessoaFOTO.LoadFromFile(opd.FileName);
  end;
end;

procedure TfrmCadPessoa.btCancelarClick(Sender: TObject);
begin
  inherited;
  with dm do Cancelar(cdsPessoa);
end;

procedure TfrmCadPessoa.btGravarClick(Sender: TObject);
begin
  with dm do Gravar(cdsPessoa);
  inherited;
end;

procedure TfrmCadPessoa.DBImage1DblClick(Sender: TObject);
begin
  inherited;
  if opd.Execute then
    dm.cdsPessoaFOTO.LoadFromFile(opd.FileName);
end;

procedure TfrmCadPessoa.DBMemo1KeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  key := UpCase(Key);
end;

procedure TfrmCadPessoa.FormShow(Sender: TObject);
begin
  inherited;
  Label6.Caption := AnsiUpperCase(NOME_GRUPO1);
  Label8.Caption := AnsiUpperCase(NOME_GRUPO2);

  dm.carrega_foto_pessoa(TBlobField(dm.cdsPessoaFOTO), img);
end;

end.
