unit uConsGrupo2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCons, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls;

type
  TfrmConsGrupo2 = class(TfrmModeloCons)
    DBMemo1: TDBMemo;
    procedure btAlterarClick(Sender: TObject);
    procedure btCadastrarClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure btPesquisaClick(Sender: TObject);
    procedure btTransferirClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsGrupo2: TfrmConsGrupo2;

implementation

uses uDM, uLib, uCadGrupo2;

{$R *.dfm}

procedure TfrmConsGrupo2.btAlterarClick(Sender: TObject);
begin
  inherited;
  AbreForm(TfrmCadGrupo2, frmCadGrupo2);
end;

procedure TfrmConsGrupo2.btCadastrarClick(Sender: TObject);
begin
  inherited;
  with dm do Inserir(cdsGrupo2);
  AbreForm(TfrmCadGrupo2, frmCadGrupo2);
end;

procedure TfrmConsGrupo2.btExcluirClick(Sender: TObject);
begin
  inherited;
  with dm do Excluir(cdsGrupo2, 'DESCRICAO');
end;

procedure TfrmConsGrupo2.btPesquisaClick(Sender: TObject);
begin
  with dm.cdsGrupo2 do
  begin
    Close;
    Params.ParamByName('DESCRICAO').AsString := edtPesquisa.Text+'%';
    Open;
  end;
  inherited;
end;

procedure TfrmConsGrupo2.btTransferirClick(Sender: TObject);
begin
  CodGrupo2 := dm.cdsGrupo2CODGRUPO.AsInteger;
  inherited;
end;

procedure TfrmConsGrupo2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with dm.cdsGrupo1 do
  begin
    Params.ParamByName('DESCRICAO').Clear;
    Close;
  end;
  inherited;
end;

procedure TfrmConsGrupo2.FormShow(Sender: TObject);
begin
  inherited;
  Label1.Caption := AnsiUpperCase( NOME_GRUPO2 );
  Caption := 'CONSULTA DE ' + AnsiUpperCase( NOME_GRUPO2 );
  btPesquisa.Click;
end;

end.
