unit uConsPessoa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCons, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls;

type
  TfrmConsPessoa = class(TfrmModeloCons)
    BitBtn1: TBitBtn;
    Label4: TLabel;
    DBText3: TDBText;
    Label3: TLabel;
    DBText1: TDBText;
    procedure btCadastrarClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure btTransferirClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btPesquisaClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsPessoa: TfrmConsPessoa;

implementation

uses uDM, uCadEvento, uLib, uCadPessoa;

{$R *.dfm}

procedure TfrmConsPessoa.btAlterarClick(Sender: TObject);
begin
  inherited;
  AbreForm(TfrmCadPessoa, frmCadPessoa);
end;

procedure TfrmConsPessoa.btCadastrarClick(Sender: TObject);
begin
  inherited;
  with dm do Inserir(cdsPessoa);
  AbreForm(TfrmCadPessoa, frmCadPessoa);
end;

procedure TfrmConsPessoa.btExcluirClick(Sender: TObject);
begin
  inherited;
  with dm do Excluir(cdsPessoa, 'NOME');
end;

procedure TfrmConsPessoa.btPesquisaClick(Sender: TObject);
begin
  with dm.cdsPessoa do
  begin
    Close;
    Params.ParamByName('NOME').AsString := edtPesquisa.Text+'%';
    Open;
  end;
  inherited;
end;

procedure TfrmConsPessoa.btTransferirClick(Sender: TObject);
begin
  CodPessoa := dm.cdsPessoa.FieldByName('CODPESSOA').AsInteger;
  inherited;
end;

procedure TfrmConsPessoa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with dm.cdsPessoa do
  begin
    Params.ParamByName('NOME').Clear;
    Close;
  end;
  inherited;
end;

procedure TfrmConsPessoa.FormShow(Sender: TObject);
begin
  inherited;
  DBGrid1.Columns[6].Title.Caption := AnsiUpperCase(NOME_GRUPO1);
  DBGrid1.Columns[8].Title.Caption := AnsiUpperCase(NOME_GRUPO2);
end;

end.
