unit uFrmModeloCad;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, DBGrids, DBCtrls, ComCtrls, Mask,
  MaskUtils;

type
  TfrmModeloCad = class(TForm)
    PanelDados: TPanel;
    PanelBotoes: TPanel;
    btGravar: TBitBtn;
    btCancelar: TBitBtn;
    procedure btCancelarClick(Sender: TObject);
    procedure btGravarClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    Anterior: TDBEdit;
    OnEnterColor, OnExitColor: Integer;
    procedure MyControlChange(Sender: TObject);
    procedure MyControlClick(Sender: TObject);
    procedure MyFilledMask(Sender: TObject; var Key: Word; Shift: TShiftState);
  public
    { Public declarations }
  end;

var
  frmModeloCad: TfrmModeloCad;

implementation

uses uLib;

{$R *.dfm}

procedure TfrmModeloCad.btCancelarClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmModeloCad.btGravarClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmModeloCad.FormCreate(Sender: TObject);
begin
  OnExitColor := clWindow;
  OnEnterColor := clSkyBlue;
end;

procedure TfrmModeloCad.FormKeyPress(Sender: TObject; var Key: Char);
begin
  case Key of
  #13:
    if (not (ActiveControl is TDBGrid)) then
    begin
      Key := #0;
      Perform(WM_NEXTDLGCTL, 0, 0);
    end
    else
      if (ActiveControl is TDBGrid) then
        with TDBGrid(ActiveControl) do
          if selectedindex < (fieldcount -1) then
            selectedindex := selectedindex +1
          else
            selectedindex := 0;
  #27: begin
         if (ActiveControl is TDBEdit) then
         with (ActiveControl as TDBEdit) do
           if IsMasked then
             if not DataSource.DataSet.FieldByName(DataField).IsNull then
             begin
               DataSource.DataSet.FieldByName(DataField).Clear;
               exit;
             end;

         key := #0;
         btCancelar.Click;
       end;
  end;
end;

procedure TfrmModeloCad.FormShow(Sender: TObject);
var
  i: integer;
begin
  //direciona a procedure que controla a cor dos componenes
  Screen.OnActiveControlChange := MyControlChange;

  //verifica quais components que so somente leitura ou na cor preta
  //para vincular ao mtodo de campos bloqueados
  //verifica tambm qual campo possui mscara
  for i:=0 to ComponentCount-1 do
    if (Components[i] is TDBEdit) then
      with (Components[i] as TDBEDit) do
      begin
        //verifica se  campo controlado pelo sistema
        if (Color = clBlack) or ReadOnly then
           OnClick := MyControlClick;

        //verifica se  campo com mscara
        if IsMasked then
          OnKeyUp := MyFilledMask;
      end
    else
      if (Components[i] is TDateTimePicker) then
        (Components[i] as TDateTimePicker).Format := ShortDateFormat;

end;

procedure TfrmModeloCad.MyControlChange(Sender: TObject);
begin
  if Assigned(Anterior) then Anterior.Color := onExitColor;

  if (ActiveControl is TDBEdit) then
    if (ActiveControl as TDBEdit).Color=clBlack then
      exit;

  if (ActiveControl is TDBEdit) or
     (ActiveControl is TDBMemo) or
     (ActiveControl is TDBComboBox) then
  begin
    TEdit(ActiveControl).Color := OnEnterColor;
    Anterior := TDBEdit(ActiveControl);
  end
  else
    Anterior := nil;
end;

procedure TfrmModeloCad.MyControlClick(Sender: TObject);
begin
  Alerta('Campo controlado pelo sistema!');
  with (Sender as TDBEdit) do
  begin
    if Color=clBlack then
      Self.Perform(WM_NEXTDLGCTL, 0, 0)
    else
      if ReadOnly then
        Self.Perform(WM_NEXTDLGCTL, 1, 0);
  end;
  Abort;
end;

procedure TfrmModeloCad.MyFilledMask(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
(* Cdigo Word para as teclas:
  BackSpace = 8
  Tab       = 9
  Enter     = 13
  Shift     = 16
  Ctrl      = 17
  Alt       = 18
  Caps Lock = 20
  Esc       = 27
  Espaco    = 32
  End       = 35
  Home      = 36
  Seta Tras = 37
  Seta Cima = 38
  Seta Frent= 39
  Seta Baixo= 40
  Delete    = 46
  :         = 58
  ;         = 59
  Menos (-)*= 109
  Barra (/)*= 111
  Num Lock  = 144
  Menos (-) = 189
  Ponto (.) = 190
  Barra (/) = 193
  Ponto (.)*= 194

  * = Teclas do Teclado Numrico
*)
  if key in [8, 9, 13, 16, 17, 18, 20, 27, 32, 35, 36, 37, 38,
             39, 40, 46, 58, 59, 109, 111, 144, 189, 190, 193, 194] then exit;
  with (Sender as TDBEdit) do
    if Length(trim(Text)) = Length(Text) then
      Self.Perform(WM_NextDlgCtl,0,0);
end;

end.
