unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ValEdit, ExtDlgs;

type
  TForm1 = class(TForm)
    ValueListEditor1: TValueListEditor;
    OpenPictureDialog1: TOpenPictureDialog;
    procedure FormCreate(Sender: TObject);
    procedure ValueListEditor1Validate(Sender: TObject; ACol, ARow: Integer;
      const KeyName, KeyValue: string);
    procedure ValueListEditor1GetPickList(Sender: TObject;
      const KeyName: string; Values: TStrings);
    procedure ValueListEditor1EditButtonClick(Sender: TObject);
  private
    { Private declarations }
  public

  ListaEstados : TStringList;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // adiciono um campo de ID
ValueListEditor1.InsertRow('ID', 'Delphi001', false);
// Coloco o campo como read-only
ValueListEditor1.ItemProps[0].ReadOnly := true;
// O nmero de telefone sera formatado
ValueListEditor1.ItemProps['Telefone'].EditMask := '!\(99\)0000-0000;1';
// adiciona um campo foto na ltima linha
ValueListEditor1.InsertRow('Foto','',True);
ValueListEditor1.ItemProps['Foto'].EditStyle := esEllipsis;
end;

procedure TForm1.ValueListEditor1EditButtonClick(Sender: TObject);
begin
  if (ValueListEditor1.Row = 9) and (OpenPictureDialog1.Execute) then
    ValueListEditor1.Values['Foto'] := OpenPictureDialog1.FileName;
end;

procedure TForm1.ValueListEditor1GetPickList(Sender: TObject;
  const KeyName: string; Values: TStrings);
begin
  if( KeyName = 'Estado') then
    begin
    Values.Add('Acre');
    Values.Add('Alagoas');
    Values.Add('Amap');
    Values.Add('Amazonas');
    Values.Add('Bahia');
    Values.Add('Cear');
    Values.Add('Distrito Federal');
    Values.Add('Esprito Santo');
    Values.Add('Gois');
    Values.Add('Maranho');
    Values.Add('Mato Grosso');
    Values.Add('Mato Grosso do Sul');
    Values.Add('Minas Gerais');
    Values.Add('Par');
    Values.Add('Paraba');
    Values.Add('Paran');
    Values.Add('Pernambuco');
    Values.Add('Piau');
    Values.Add('Rio de Janeiro');
    Values.Add('Rio Grande do Norte');
    Values.Add('Rio Grande do Sul');
    Values.Add('Rondnia');
    Values.Add('Santa Catarina');
    Values.Add('So Paulo');
    Values.Add('Sergipe');
    Values.Add('Tocantins');
    end;
end;

procedure TForm1.ValueListEditor1Validate(Sender: TObject; ACol, ARow: Integer;
  const KeyName, KeyValue: string);

begin
  if (KeyName = 'CEP') and ((StrToInt(KeyValue)) < 0) then
    raise Exception.Create('CEP Invlido');
end;

end.
