unit uCadPessoa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCad, StdCtrls, Buttons, ExtCtrls, DBCtrls, DB, Mask,
  ExtDlgs, JPEG, Videocap, ClipBrd, Grids, DBGrids, ImgList, DBClient;

type
  TfrmCadPessoa = class(TfrmModeloCad)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    DBEdit5: TDBEdit;
    Label6: TLabel;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    Label8: TLabel;
    DBEdit8: TDBEdit;
    DBEdit9: TDBEdit;
    Label10: TLabel;
    DBEdit10: TDBEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    DBMemo1: TDBMemo;
    DBComboBox1: TDBComboBox;
    opd: TOpenPictureDialog;
    pFoto: TPanel;
    bCapturar: TBitBtn;
    bSelecionar: TBitBtn;
    bLimpar: TBitBtn;
    img: TImage;
    VideoCap1: TVideoCap;
    Panel1: TPanel;
    Label7: TLabel;
    bTodos: TSpeedButton;
    bNenhum: TSpeedButton;
    Label9: TLabel;
    Panel2: TPanel;
    Label14: TLabel;
    lQtde: TLabel;
    Label16: TLabel;
    lTotal: TLabel;
    gParticipacoes: TDBGrid;
    cdsP: TClientDataSet;
    dsP: TDataSource;
    cdsPPARTICIPA: TStringField;
    cdsPCODEVENTO: TIntegerField;
    cdsPNOMEEVENTO: TStringField;
    cdsPDATAPGTO: TDateField;
    cdsPPRESENTE: TStringField;
    cdsPDATA: TDateField;
    cdsPHORA: TStringField;
    cdsPTOTAL: TAggregateField;
    ImageList1: TImageList;
    cdsPVALOR: TFMTBCDField;
    procedure DBMemo1KeyPress(Sender: TObject; var Key: Char);
    procedure btGravarClick(Sender: TObject);
    procedure btCancelarClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DBImage1DblClick(Sender: TObject);
    procedure bSelecionarClick(Sender: TObject);
    procedure bLimparClick(Sender: TObject);
    procedure bCapturarClick(Sender: TObject);
    procedure gParticipacoesDblClick(Sender: TObject);
    procedure gParticipacoesKeyPress(Sender: TObject; var Key: Char);
    procedure bTodosClick(Sender: TObject);
    procedure cdsPAfterPost(DataSet: TDataSet);
    procedure gParticipacoesDrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure cdsPPRESENTEGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    procedure carrega_eventos_pessoa;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCadPessoa: TfrmCadPessoa;

implementation

uses uDM, uLib;

{$R *.dfm}

procedure TfrmCadPessoa.bCapturarClick(Sender: TObject);
var
  BMP: TBitMap;
  JPG: TJpegImage;
  arq_foto: String;
begin
  inherited;
  arq_foto := ExtractFilePath(Application.ExeName) + 'foto.jpg';

  if bCapturar.Caption = 'Cap&turar' then
  begin
    VideoCap1.DriverIndex := 0;
    try
      VideoCap1.Visible := True;
      VideoCap1.VideoPreview := True;
      bCapturar.Caption := '&Tirar Foto';
    except
      VideoCap1.VideoPreview := False;
      VideoCap1.Visible := False;
      bCapturar.Caption := 'Cap&turar';
      Alerta('No foi possvel inicializar a cmera!');
    end
  end
  else
  begin
    VideoCap1.SaveToClipboard;
    BMP := TBitMap.Create;
    try
      BMP.LoadFromClipboardFormat(cf_BitMap,ClipBoard.GetAsHandle(cf_Bitmap),0);
      JPG := TJpegImage.Create;
      try
        JPG.Assign(BMP);
        JPG.SaveToFile(arq_foto);
        img.Picture.LoadFromFile(arq_foto);
        dm.cdsPessoaFOTO.LoadFromFile(arq_foto);
      finally
        JPG.Free;
      end;
    finally
      BMP.Free;
    end;
    Clipboard.Clear;
    VideoCap1.VideoPreview := False;
    VideoCap1.Visible := False;
    bCapturar.Caption := 'Cap&turar';
  end;
end;

procedure TfrmCadPessoa.bLimparClick(Sender: TObject);
begin
  inherited;
  with dm.cdsPessoa do
    if not (State in dsEditModes) then
      Edit;
  img.Picture.Assign(nil);
  dm.cdsPessoaFOTO.Clear;
  pFoto.Caption := 'Sem Foto';
end;

procedure TfrmCadPessoa.bSelecionarClick(Sender: TObject);
begin
  inherited;
  if opd.Execute then
  begin
    with dm.cdsPessoa do
      if not (State in dsEditModes) then
        Edit;
    img.Picture.LoadFromFile(opd.FileName);
    dm.cdsPessoaFOTO.LoadFromFile(opd.FileName);
  end;
end;

procedure TfrmCadPessoa.btCancelarClick(Sender: TObject);
begin
  inherited;
  with dm do Cancelar(cdsPessoa);
end;

procedure TfrmCadPessoa.btGravarClick(Sender: TObject);
begin
  //se houve alteraes na tabela temporria
  if cdsP.ChangeCount > 0 then
  begin

    cdsP.DisableControls;
    try
      //Apaga os que foram Desmarcados no cdsP
      cdsP.Filtered := False;
      cdsP.Filter := 'PARTICIPA = ''F''';
      cdsP.Filtered := True;
      cdsP.First;
      while not cdsP.Eof do
      begin
        dm.cdsParticipacoes.First;
        if dm.cdsParticipacoes.Locate('CODEVENTO',
          cdsPCODEVENTO.Value, []) then
          dm.cdsParticipacoes.Delete;

        cdsP.Next;
      end;

      //Insere os que foram Marcados no cdsP
      cdsP.Filtered := False;
      cdsP.Filter := 'PARTICIPA = ''T''';
      cdsP.Filtered := True;
      cdsP.First;
      while not cdsP.Eof do
      begin
        dm.cdsParticipacoes.First;
        if not dm.cdsParticipacoes.Locate('CODEVENTO',
          cdsPCODEVENTO.Value, []) then
        begin
          dm.cdsParticipacoes.Append;
          dm.cdsParticipacoesCODEVENTO.Value :=
            cdsPCODEVENTO.Value;
          dm.cdsParticipacoesPRESENTE.Value :=
            cdsPPRESENTE.Value;
          if not cdsPDATAPGTO.IsNull then
            dm.cdsParticipacoesPAGOEM.AsDateTime :=
              cdsPDATAPGTO.AsDateTime;
          dm.cdsParticipacoes.Post;
        end;

        cdsP.Next;
      end;
    finally
      cdsP.Filter := '';
      cdsP.Filtered := False;
      cdsP.First;
      cdsP.EnableControls;
    end;
  end;

  with dm do Gravar(cdsPessoa);

  cdsP.EmptyDataSet;
  cdsP.Close;
  inherited;
end;

procedure TfrmCadPessoa.bTodosClick(Sender: TObject);
var
  R: TBookMark;
begin
  inherited;

  //captura a posio atual do cursor no cdsP
  R := cdsP.GetBookmark;

  //desativa os controles para o usurio no
  //perceber o loop nos eventos e ainda otimizar
  //a performance
  cdsP.DisableControls;
  try
    //percorre o cdsP
    cdsP.First;
    while not cdsP.Eof do
    begin
      cdsP.Edit;
      //identifica o boto que chamou o mtodo e
      //atribui o valor correto ao campo PARTICIPA
      if Sender = bTodos then
        cdsPPARTICIPA.Value := 'T'
      else if Sender = bNenhum then
        cdsPPARTICIPA.Value := 'F';
      cdsP.Post;
      cdsP.Next;
    end;
  finally
    //ativa os controles
    cdsP.EnableControls;
  end;

  //volta o cursor  posio original
  try cdsP.GotoBookmark(R); except end;
  try cdsP.FreeBookmark(R); except end;
end;

procedure TfrmCadPessoa.DBImage1DblClick(Sender: TObject);
begin
  inherited;
  if opd.Execute then
    dm.cdsPessoaFOTO.LoadFromFile(opd.FileName);
end;

procedure TfrmCadPessoa.DBMemo1KeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  key := UpCase(Key);
end;

procedure TfrmCadPessoa.carrega_eventos_pessoa;
begin
  //cria o cdsP em memria
  cdsP.CreateDataSet;
  //desativa seus controles
  cdsP.DisableControls;
  try
    with dm.cdsEvento do
    begin
      //lista todos os eventos cadastrados
      Close;
      Params.ParamByName('NOME').AsString := '%';
      Open;
      //para cada Evento
      while not Eof do
      begin
        //insere-o no cdsP (temporario)
        cdsP.Append;

        //preenche os campos do cdsP
        cdsPCODEVENTO.Value :=
           FieldByName('CODEVENTO').AsInteger;
        cdsPNOMEEVENTO.Value :=
          FieldByName('NOME').AsString;
        if not FieldByName('DATA').IsNull then
          cdsPDATA.Value := FieldByName('DATA').Value;
        cdsPHORA.Value := FieldByName('HORA').AsString;
        cdsPVALOR.Value := FieldByName('VALOR').AsBCD;

        //se  uma Incluso de Pessoa
        if dm.dsPessoa.State = dsInsert then
        begin
          //Seleciona automaticamente os eventos gratuitos
          if cdsPVALOR.AsFloat = 0 then
          begin
            cdsPDATAPGTO.Value := Now;
            cdsPPARTICIPA.Value := 'T';
          end;
        end
        else //se  uma alterao de uma pessoa cadastrada
        begin
          //verifica se a pessoa j no est inscrita no
          //evento que est sendo inserido no cdsP
          dm.cdsParticipacoes.First;
          if dm.cdsParticipacoes.Locate(
            'CODEVENTO', cdsPCODEVENTO.AsInteger, []) then
          begin
            cdsPPARTICIPA.Value := 'T';
            if (not dm.cdsParticipacoesPAGOEM.IsNull) and
               (dm.cdsParticipacoesPAGOEM.AsString <> '30/12/1899') then
              cdsPDATAPGTO.Value := dm.cdsParticipacoesPAGOEM.AsDateTime;
            cdsPPRESENTE.Value := dm.cdsParticipacoesPRESENTE.Value;
          end;
        end;

        cdsP.Post;
        Next;
      end;
      Close;
    end;
  finally
    cdsP.First;
    cdsP.EnableControls;
  end;
end;

procedure TfrmCadPessoa.cdsPAfterPost(DataSet: TDataSet);
var
  R: TBookMark;
begin
  inherited;
  //pega a posio atual do cursor no cdsP
  R := cdsP.GetBookmark;

  cdsP.DisableControls;
  try
    //filtra somente os eventos inscritos
    cdsP.Filtered := False;
    cdsP.Filter := 'PARTICIPA = ''T''';
    cdsP.Filtered := True;

    //captura a quantidade de eventos inscritos
    lQtde.Caption := IntToStr(cdsP.RecordCount);
    //captura o total dos eventos inscritos (campo aggregate)
    if (cdsPTOTAL.IsNull) or (cdsPTOTAL.AsString = '') then
      lTotal.Caption := CurrencyString + ' 0,00'
    else
      lTotal.Caption := CurrencyString +
         FormatFloat('#,##0.00', cdsPTOTAL.Value);

    //limpa o filtro do cdsP
    cdsP.Filtered := False;
    cdsP.Filter := '';
  finally
    cdsP.EnableControls;
  end;

  //volta o cursor na posio anterior
  try cdsP.GotoBookmark(R); except end;
  try cdsP.FreeBookmark(R); except end;
end;

procedure TfrmCadPessoa.cdsPPRESENTEGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  inherited;
  if Sender.IsNull or (Sender.AsString = '') then Exit;
  case Sender.AsString[1] of
    'T': Text := 'SIM';
    'F': Text := 'NO';
  else
    Text := '';
  end;
end;

procedure TfrmCadPessoa.FormShow(Sender: TObject);
begin
  Label6.Caption := AnsiUpperCase(NOME_GRUPO1);
  Label8.Caption := AnsiUpperCase(NOME_GRUPO2);

  dm.carrega_foto_pessoa(TBlobField(dm.cdsPessoaFOTO), img);

  carrega_eventos_pessoa;

  inherited;
end;

procedure TfrmCadPessoa.gParticipacoesDblClick(Sender: TObject);
begin
  inherited;
  if cdsP.IsEmpty then
  begin
    Alerta('Nenhum Evento Cadastrado!');
    exit;
  end;

  try
    cdsP.Edit;
    cdsPPARTICIPA.AsBoolean := not cdsPPARTICIPA.AsBoolean;
    cdsP.Post;
  except on E: Exception do
  end;
end;

procedure TfrmCadPessoa.gParticipacoesDrawColumnCell(Sender: TObject;
  const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
  R: TRect;
begin
  inherited;

  //pinta checkbox, caso seja a coluna PARTICIPA
  if Column.Field = cdsPPARTICIPA then
  begin
    //desenho padro da coluna
    gParticipacoes.Canvas.FillRect(Rect);
    //desenha a imagem 0 do ImageList (checkbox)
    ImageList1.Draw(gParticipacoes.Canvas,
      Rect.Left+18, Rect.Top+1, 0);
    //se PARTICIPA = 'T'
    if cdsPPARTICIPA.AsBoolean then
      //desenha a imagem 2 do ImageList (marcado)
      ImageList1.Draw(gParticipacoes.Canvas,
        Rect.Left+18, Rect.Top+1, 2)
    else //PARTICIPA = 'F'
      //desenha a imagem 1 do ImageList (desmarcado)
      ImageList1.Draw(gParticipacoes.Canvas,
        Rect.Left+18, Rect.Top+1, 1);
  end;

  //destaca campo PRESENTE
   if Column.Field = cdsPPRESENTE then
    // se a clula no est selecionada
    if not (gdSelected in State) then
      //se PRESENTE = 'F'
      if not cdsPPRESENTE.AsBoolean then
      begin
        gParticipacoes.Canvas.FillRect(Rect);
        R := Rect;
        R.Left := R.Left + 5;
        gParticipacoes.Canvas.Font.Color := clRed;
        // pinta o texto padro
        gParticipacoes.DefaultDrawDataCell(R,Column.Field,State);
      end;
end;

procedure TfrmCadPessoa.gParticipacoesKeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  if Key = ' ' then
    gParticipacoesDblClick(gParticipacoes);
end;

end.
