unit uDM;

interface

uses
  SysUtils, Classes, WideStrings, TBODbxDynalink, DB, SqlExpr, FMTBcd, Provider,
  DBClient, Controls, Forms, DBXCommon, DBCommonTypes, DBXTrace, DBXInterbase,
  ExtCtrls, JPEG;

type
  Tdm = class(TDataModule)
    Banco: TSQLConnection;
    qryGrupo1: TSQLQuery;
    qryGrupo1CODGRUPO: TIntegerField;
    qryGrupo1DESCRICAO: TStringField;
    qryGrupo1OBSERVACAO: TMemoField;
    dspGrupo1: TDataSetProvider;
    cdsGrupo1: TClientDataSet;
    qryAux: TSQLQuery;
    cdsGrupo1CODGRUPO: TIntegerField;
    cdsGrupo1DESCRICAO: TStringField;
    cdsGrupo1OBSERVACAO: TMemoField;
    dsGrupo1: TDataSource;
    qryGrupo2: TSQLQuery;
    qryEvento: TSQLQuery;
    qryGrupo2CODGRUPO: TIntegerField;
    qryGrupo2DESCRICAO: TStringField;
    qryGrupo2OBSERVACAO: TMemoField;
    qryEventoCODEVENTO: TIntegerField;
    qryEventoNOME: TStringField;
    qryEventoVALOR: TFMTBCDField;
    qryEventoDATA: TDateField;
    qryEventoHORA: TStringField;
    qryEventoLOCAL: TStringField;
    qryEventoPALESTRANTE: TStringField;
    qryEventoOBSERVACAO: TMemoField;
    dspGrupo2: TDataSetProvider;
    dspEvento: TDataSetProvider;
    cdsGrupo2: TClientDataSet;
    cdsEvento: TClientDataSet;
    dsGrupo2: TDataSource;
    dsEvento: TDataSource;
    cdsGrupo2CODGRUPO: TIntegerField;
    cdsGrupo2DESCRICAO: TStringField;
    cdsGrupo2OBSERVACAO: TMemoField;
    cdsEventoCODEVENTO: TIntegerField;
    cdsEventoNOME: TStringField;
    cdsEventoVALOR: TFMTBCDField;
    cdsEventoDATA: TDateField;
    cdsEventoHORA: TStringField;
    cdsEventoLOCAL: TStringField;
    cdsEventoPALESTRANTE: TStringField;
    cdsEventoOBSERVACAO: TMemoField;
    qryPessoa: TSQLQuery;
    dspPessoa: TDataSetProvider;
    cdsPessoa: TClientDataSet;
    dsPessoa: TDataSource;
    qryPessoaCODPESSOA: TIntegerField;
    qryPessoaNOME: TStringField;
    qryPessoaAPELIDO: TStringField;
    qryPessoaRG: TStringField;
    qryPessoaCPF: TStringField;
    qryPessoaGRUPO1: TIntegerField;
    qryPessoaGRUPO2: TIntegerField;
    qryPessoaINSCRICAO: TSQLTimeStampField;
    qryPessoaEMITIUCRACHA: TStringField;
    qryPessoaFOTO: TBlobField;
    qryPessoaSEXO: TStringField;
    cdsPessoaCODPESSOA: TIntegerField;
    cdsPessoaNOME: TStringField;
    cdsPessoaAPELIDO: TStringField;
    cdsPessoaRG: TStringField;
    cdsPessoaCPF: TStringField;
    cdsPessoaGRUPO1: TIntegerField;
    cdsPessoaGRUPO2: TIntegerField;
    cdsPessoaINSCRICAO: TSQLTimeStampField;
    cdsPessoaEMITIUCRACHA: TStringField;
    cdsPessoaFOTO: TBlobField;
    cdsPessoaSEXO: TStringField;
    qryPessoaNOMEGRUPO1: TStringField;
    qryPessoaNOMEGRUPO2: TStringField;
    cdsPessoaNOMEGRUPO1: TStringField;
    cdsPessoaNOMEGRUPO2: TStringField;
    qryPessoaOBSERVACAO: TMemoField;
    cdsPessoaOBSERVACAO: TMemoField;
    dsLinkParticip: TDataSource;
    dsParticipacoes: TDataSource;
    qryParticipacoes: TSQLQuery;
    cdsParticipacoes: TClientDataSet;
    qryParticipacoesCODPESSOA: TIntegerField;
    qryParticipacoesCODEVENTO: TIntegerField;
    qryParticipacoesNOME: TStringField;
    qryParticipacoesVALOR: TFMTBCDField;
    qryParticipacoesPAGOEM: TSQLTimeStampField;
    qryParticipacoesPRESENTE: TStringField;
    cdsPessoaqryParticipacoes: TDataSetField;
    cdsParticipacoesCODPESSOA: TIntegerField;
    cdsParticipacoesCODEVENTO: TIntegerField;
    cdsParticipacoesNOME: TStringField;
    cdsParticipacoesVALOR: TFMTBCDField;
    cdsParticipacoesPAGOEM: TSQLTimeStampField;
    cdsParticipacoesPRESENTE: TStringField;
    cdsParticipacoesQTDE: TAggregateField;
    cdsParticipacoesTOTAL: TAggregateField;
    procedure DataModuleCreate(Sender: TObject);
    procedure ShowDSPUpdateError(Sender: TObject;
      DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
      var Response: TResolverResponse);
    procedure dspGrupo1BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
      var Applied: Boolean);
    procedure dspGrupo2BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
      var Applied: Boolean);
    procedure dspEventoBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure cdsPessoaSEXOSetText(Sender: TField; const Text: string);
    procedure cdsPessoaAfterInsert(DataSet: TDataSet);
    procedure cdsPessoaSEXOGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
    procedure cdsPessoaGRUPO1Validate(Sender: TField);
    procedure cdsPessoaGRUPO2Validate(Sender: TField);
    procedure dspPessoaBeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
      var Applied: Boolean);
    procedure cdsParticipacoesBeforeDelete(DataSet: TDataSet);
    procedure cdsPessoaBeforeDelete(DataSet: TDataSet);
    procedure SimNaoGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    { Private declarations }
    FNewCodPessoa: Integer;
  public
    { Public declarations }
    procedure Cancelar(var aCDS: TClientDataSet);
    procedure Excluir(var aCDS: TClientDataSet; aDialogField: String);
    function GetDeleteErrorMsg(msg: string): string;
    procedure Gravar(var aCDS: TClientDataSet);
    procedure Inserir(var aCDS: TClientDataSet);
    procedure carrega_foto_pessoa(_f: TBlobField; var _i: TImage);
  end;

var
  dm: Tdm;

  //variveis que guardaro a configurao dos
  //nomes dos grupos
  NOME_GRUPO1,
  NOME_GRUPO2: String;

  //variveis utilizadas nas consultas
  CodGrupo1,
  CodGrupo2,
  CodEvento,
  CodPessoa: Integer;

implementation

uses uLib;

{$R *.dfm}

procedure Tdm.cdsParticipacoesBeforeDelete(DataSet: TDataSet);
begin
  with cdsPessoa do
    if not (State in dsEditModes) then Edit;
end;

procedure Tdm.SimNaoGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  if Sender.IsNull or (Sender.AsString = '') then Exit;
  case Sender.AsString[1] of
    'T': Text := 'SIM';
    'F': Text := 'NO';
  else
    Text := '';
  end;
end;

procedure Tdm.cdsPessoaAfterInsert(DataSet: TDataSet);
begin
  cdsPessoaINSCRICAO.AsString := FormatDateTime(
    ShortDateFormat + ' ' + LongTimeFormat, Now);
end;

procedure Tdm.cdsPessoaBeforeDelete(DataSet: TDataSet);
begin
  with cdsParticipacoes do
    while not Eof do Delete;
end;

procedure Tdm.cdsPessoaGRUPO1Validate(Sender: TField);
begin
  if Sender.AsString <> '' then
  begin
    cdsPessoaNOMEGRUPO1.AsString := GetFieldByID(Banco,
      'GRUPO1', 'DESCRICAO', 'CODGRUPO', Sender.AsInteger);
    if cdsPessoaNOMEGRUPO1.AsString = '' then
    begin
      Alerta(NOME_GRUPO1 + ' - Registro No Localizado!');
      abort;
    end;
  end
  else
    cdsPessoaNOMEGRUPO1.Clear;
end;

procedure Tdm.cdsPessoaGRUPO2Validate(Sender: TField);
begin
  if Sender.AsString <> '' then
  begin
    cdsPessoaNOMEGRUPO2.AsString := GetFieldByID(Banco,
      'GRUPO2', 'DESCRICAO', 'CODGRUPO', Sender.AsInteger);
    if cdsPessoaNOMEGRUPO2.AsString = '' then
    begin
      Alerta(NOME_GRUPO2 + ' - Registro No Localizado!');
      abort;
    end;
  end
  else
    cdsPessoaNOMEGRUPO2.Clear;
end;

procedure Tdm.cdsPessoaSEXOGetText(Sender: TField; var Text: string;
  DisplayText: Boolean);
begin
  if (Sender.IsNull) or (Sender.AsString = '') then exit;
  case Sender.AsString[1] of
    'M': Text := 'MASCULINO';
    'F': Text := 'FEMININO';
  else
    Text := '';
  end;
end;

procedure Tdm.cdsPessoaSEXOSetText(Sender: TField; const Text: string);
begin
  if Trim(Text)<>'' then
    Sender.AsString := Text[1];
end;

procedure Tdm.DataModuleCreate(Sender: TObject);
begin
  NOME_GRUPO1 := 'Curso';
  NOME_GRUPO2 := 'Perodo';

  Banco.KeepConnection := True;
  try
    Banco.Open;
  except
    on E: Exception do
    begin
      Alerta('No foi possvel conectar ao banco de dados:' + #13#10#13#10 +
        E.Message);
      Halt;
    end;
  end;

  ShortDateFormat := 'DD/MM/YYYY';
  ShortTimeFormat := 'HH:NN:SS';
end;

procedure Tdm.dspEventoBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind;
  var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryEvento then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODEVENTO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODEVENTO').NewValue :=
          GetGenValue(Banco,'GEN_CODEVENTO',1);
  End;
end;

procedure Tdm.dspGrupo1BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryGrupo1 then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODGRUPO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODGRUPO').NewValue :=
          GetGenValue(Banco,'GEN_CODGRUPO',1);
  End
  //se  alterao
  else if UpdateKind = ukModify then
    //e se o CODGRUPO foi modificado pelo usurio
    if DeltaDS.FieldByName('CODGRUPO').OldValue <>
       DeltaDS.FieldByName('CODGRUPO').NewValue then
    //altera as pessoas vinculadas ao grupo
    begin
      qryAux.Close;
      qryAux.SQL.Text := 'UPDATE PESSOAS SET GRUPO1 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').NewValue) +
        ' WHERE GRUPO1 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').OldValue);
      qryAux.ExecSQL;
    end;
end;

procedure Tdm.dspGrupo2BeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    if SourceDS = qryGrupo2 then
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODGRUPO').AsInteger = 0 then
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        DeltaDS.FieldByName('CODGRUPO').NewValue :=
          GetGenValue(Banco,'GEN_CODGRUPO2',1);
  End
  //se  alterao
  else if UpdateKind = ukModify then
    //e se o CODGRUPO foi modificado pelo usurio
    if DeltaDS.FieldByName('CODGRUPO').OldValue <>
       DeltaDS.FieldByName('CODGRUPO').NewValue then
    //altera as pessoas vinculadas ao grupo
    begin
      qryAux.Close;
      qryAux.SQL.Text := 'UPDATE PESSOAS SET GRUPO2 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').NewValue) +
        ' WHERE GRUPO2 = ' +
        IntToStr(DeltaDS.FieldByName('CODGRUPO').OldValue);
      qryAux.ExecSQL;
    end;
end;

procedure Tdm.dspPessoaBeforeUpdateRecord(Sender: TObject; SourceDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  //se  insero
  if UpdateKind = ukInsert then
  begin
    //se est trabalhando com a qryPessoa
    if SourceDS = qryPessoa then
    begin
      //se o usurio no informou um cdigo manualmente
      if DeltaDS.FieldByName('CODPESSOA').AsInteger = 0 then
      begin
        //gera um ID atravs da funo GetGenValue, da unit uLib.pas
        FNewCodPessoa := GetGenValue(Banco,'GEN_CODPESSOA',1);
        DeltaDS.FieldByName('CODPESSOA').NewValue := FNewCodPessoa;
      end;
    end
    else //trabalhando com qryParticipacoes
      if SourceDS = qryParticipacoes then
        if DeltaDS.FieldByName('CODPESSOA').AsInteger = 0 then
          DeltaDS.FieldByName('CODPESSOA').NewValue := FNewCodPessoa;
  end;
end;

procedure Tdm.ShowDSPUpdateError(Sender: TObject;
  DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
begin
  raise Exception.Create(E.Message);
end;

function Tdm.GetDeleteErrorMsg(msg: string): string;
begin
  Result := '';
  if pos('violation of FOREIGN KEY', msg)>0 then
    Result := #13#10#13#10+
              'O registro no pde ser excludo porque'+#13#10+
              'possui dependentes!';

  Result := 'Erro ao excluir dados!' + Result;
end;

procedure Tdm.Excluir(var aCDS: TClientDataSet; aDialogField: String);
begin
  with aCDS do
  begin
    if Confirma('Deseja realmente excluir '+
                FieldByName(aDialogField).AsString+' ?') then
    begin

      TRY
        Screen.Cursor := crSQLWait;
        Delete;
        try
          ApplyUpdates(0);
        except
          on E:Exception do
          begin
            Erro(GetDeleteErrorMsg(E.Message));
            CancelUpdates;
            abort;
          end;
        end;
      FINALLY
        Screen.Cursor := crDefault;
      END;

    end;
  end;
end;

procedure Tdm.Gravar(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    TRY
      Screen.Cursor := crSQLWait;
      if not (State in dsEditModes) then Edit;
      Post;
      try
        ApplyUpdates(0);
        //Informacao('Dados Gravados com Sucesso!');
      except
        on E: Exception do
        begin
          Erro('Erro ao gravar dados!' + #13#13 +
            'Mensagem Original:' + #13 + E.Message);
          Abort;
        end;
      end;
    FINALLY
      Screen.Cursor := crDefault;
    END;
  end;
end;

procedure Tdm.Inserir(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    TRY
      Screen.Cursor := crSQLWait;
      if not Active then Open;
      Append;
    FINALLY
      Screen.Cursor := crDefault;
    END;
  end;
end;

procedure Tdm.Cancelar(var aCDS: TClientDataSet);
begin
  with aCDS do
  begin
    if State in dsEditModes then
      if Confirma('Deseja realmente cancelar?') then
      begin
        Cancel;
        CancelUpdates;
      end
      else
        Abort;

    CancelUpdates;
  end;
end;

procedure Tdm.carrega_foto_pessoa(_f: TBlobField; var _i: TImage);
var
  MemStrm: TMemoryStream;
  Jpg: TJPEGImage;
begin
  _i.Picture.Assign(nil);

  if (not _f.IsNull) then
    try
      Jpg := TJPEGImage.Create;
      try
        MemStrm := TMemoryStream.Create;
        try
          _f.SaveToStream(MemStrm);
          MemStrm.Seek(0,soFromBeginning);
          with Jpg do
          begin
            PixelFormat := jf24Bit;
            Scale := jsFullSize;
            Grayscale := False;
            Performance := jpBestQuality;
            ProgressiveDisplay := True;
            ProgressiveEncoding := True;
            LoadFromStream(MemStrm);
          end; //with
          _i.Picture.Assign(Jpg);
        finally
          MemStrm.Free;
        end; //try
      finally
        Jpg.Free;
      end; //try
    except
      _i.Picture.Assign(nil);
    end
  else
    _i.Picture.Assign(nil);
end;

end.
