unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, uPSComponent;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Label1: TLabel;
    edtPercentual: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edtComprimento: TMaskEdit;
    edtLargura: TMaskEdit;
    edtAltura: TMaskEdit;
    GroupBox2: TGroupBox;
    cmbxScript: TComboBox;
    ps: TPSScript;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    function ObterErro: String;
    procedure CarregarScript;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type
  TFuncaoCalculoPercentual =
    function(Comprimento, Largura, Altura: double): double of object;

procedure TForm1.Button1Click(Sender: TObject);
var
  Funcao: TFuncaoCalculoPercentual;
  lPercentual: double;
begin
  CarregarScript;

  if not ps.Compile then
  begin
    ShowMessage('Erro: ' +ObterErro);
    Exit;
  end;

  Funcao := TFuncaoCalculoPercentual(ps.GetProcMethod('ObterPercentualDesconto'));

  if @Funcao = nil then
  begin
    ShowMessage('Funcao ObterPercentualDesconto no definida no Script');
    Exit;
  end;

  lPercentual := Funcao(StrToFloat(edtComprimento.Text),
    StrToFloat(edtLargura.Text), StrToFloat(edtAltura.Text));

  edtPercentual.Text := FormatFloat('#,##0.00',  lPercentual);
end;

procedure TForm1.CarregarScript;
var
  lstScript: String;
begin
  { seleciona o nome do arquivo em funo da seleo do combo box }
  case cmbxScript.ItemIndex of
    0: lstScript := 'Script1.ps';
    1: lstScript := 'Script2.ps';
    2: lstScript := 'Script3.ps';
  end;

  ps.Script.LoadFromFile(lstScript);
end;

function TForm1.ObterErro: String;
var
  i: integer;
begin
  Result := '';

  for i := 0 to ps.CompilerMessageCount - 1 do
    Result := Result + ps.CompilerMessages[i].MessageToString + #13#10;


end;

end.
