unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uPSComponent;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ps: TPSScript;
    edtDesconto: TEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FRegistrado: boolean;
    function ObterErro: String;
    procedure RegistraPlugin;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses uETCliente, uPSI_uETCliente;

{$R *.dfm}

type
  TFuncaoCalculoPercentual =
    function(Comprimento, Largura, Altura: double): double of object;

  TFuncaoAjuste =
    function(PercentualInicial: double; prCliente: TCliente): double of object;


function ObterCliente: TCliente;
begin
  Result := TCliente.Create(1, 'JUFEMIL COMERCIO E CONSTRUCOES', 'A');
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  funcaoCalculoPercentual: TFuncaoCalculoPercentual;
  funcaoAjuste: TFuncaoAjuste;
  Percentual: double;
  obCliente: TCliente;
begin
  ps.Script.LoadFromFile('Script.ps');
  RegistraPlugin;

  if not ps.Compile then
  begin
    ShowMessage('Erro: ' + ObterErro);
    Exit;
  end;

  obCliente := ObterCliente;

  try
    funcaoCalculoPercentual :=
      TFuncaoCalculoPercentual(ps.GetProcMethod('ObterPercentualDesconto'));

    if @funcaoCalculoPercentual = nil then
      raise Exception.Create('Funo ObterPercentualDesconto no definida');

    funcaoAjuste :=
      TFuncaoAjuste(ps.GetProcMethod('AjustarPercentualCliente'));

    if @funcaoAjuste = nil then
      raise Exception.Create('Funo AjustarPercentualCliente no definida');


    Percentual := funcaoCalculoPercentual(7, 0.5, 0.5);
    Percentual := funcaoAjuste(Percentual, obCliente);
  finally
    obCliente.Free;
  end;

  edtDesconto.Text := FormatFloat('#,##0.00', Percentual);
end;

function TForm1.ObterErro: String;
var
  i: integer;
begin
  Result := '';

  for i := 0 to ps.CompilerMessageCount - 1 do
    Result := Result + ps.CompilerMessages[i].MessageToString + #13#10;
end;

procedure TForm1.RegistraPlugin;
var
  PlugIn: TPSPlugin;
begin
  if FRegistrado then
    Exit;

  PlugIn := TPSImport_uETCliente.Create(Self);
  TPSPluginItem(ps.Plugins.Add).Plugin := PlugIn;
  FRegistrado := true;
end;

end.
