SET SQL DIALECT 3;

SET NAMES WIN1252;

CREATE DATABASE 'localhost:C:\ControleEventos\Dados\EVENTOS.FDB'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 4096
DEFAULT CHARACTER SET WIN1252;

/**** Domains ****/

CREATE DOMAIN DTHR AS
TIMESTAMP;

CREATE DOMAIN FONE AS
VARCHAR(14);

CREATE DOMAIN INN AS
INTEGER
NOT NULL;

CREATE DOMAIN LOGICO AS
CHAR(1)
NOT NULL;

CREATE DOMAIN MEMO AS
BLOB SUB_TYPE 1 SEGMENT SIZE 80;

CREATE DOMAIN PRECISAO AS
DOUBLE PRECISION;

CREATE DOMAIN VRALTO AS
NUMERIC(18,2);

CREATE DOMAIN VRBAIXO AS
NUMERIC(9,2);


/**** Generators ****/

CREATE GENERATOR GEN_CODEVENTO;

CREATE GENERATOR GEN_CODGRUPO;

CREATE GENERATOR GEN_CODGRUPO2;

CREATE GENERATOR GEN_CODPESSOA;


/**** Tables ****/

CREATE TABLE GRUPO1 (
    CODGRUPO    INN,
    DESCRICAO   VARCHAR(25) NOT NULL,
    OBSERVACAO  MEMO
);


CREATE TABLE GRUPO2 (
    CODGRUPO    INN,
    DESCRICAO   VARCHAR(25) NOT NULL,
    OBSERVACAO  MEMO
);


CREATE TABLE EVENTOS (
    CODEVENTO    INN,
    NOME         VARCHAR(25) NOT NULL,
    VALOR        VRALTO,
    DATA         DATE,
    HORA         VARCHAR(8),
    LOCAL        VARCHAR(100),
    PALESTRANTE  VARCHAR(50),
    OBSERVACAO   MEMO
);


CREATE TABLE PESSOAS (
    CODPESSOA     INN,
    NOME          VARCHAR(50),
    APELIDO       VARCHAR(50),
    RG            VARCHAR(20),
    CPF           VARCHAR(14),
    GRUPO1        INTEGER,
    GRUPO2        INTEGER,
    INSCRICAO     DTHR,
    EMITIUCRACHA  LOGICO,
    FOTO          BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    OBSERVACAO    MEMO,
    SEXO          CHAR(1)
);


CREATE TABLE PARTICIPACOES (
    CODPESSOA  INN,
    CODEVENTO  INN,
    PAGOEM     DTHR,
    PRESENTE   LOGICO
);


CREATE TABLE SISTEMA (
    ID                      SMALLINT NOT NULL,
    REGISTRADO_PARA         VARCHAR(100),
    VALIDADE_REGISTRO       VARCHAR(10),
    ONENTER_COLOR           INTEGER,
    IMGFUNDO                VARCHAR(200),
    EXIBIR_IMB              LOGICO,
    BARRASTATUS_COLOR       INTEGER,
    MONITORABD              LOGICO,
    LOGFILEPATH             VARCHAR(200),
    KEEPCONN                LOGICO,
    USESKIN                 LOGICO,
    SKINNAME                VARCHAR(25),
    CONGRESSO               VARCHAR(50),
    INICIO                  DATE,
    TERMINO                 DATE,
    GRUPO1                  VARCHAR(25),
    GRUPO2                  VARCHAR(25)
);


CREATE TABLE LOGS (
    DATA     DATE DEFAULT CURRENT_DATE NOT NULL,
    HORA     TIME DEFAULT CURRENT_TIME NOT NULL,
    TABELA   VARCHAR(40),
    USUARIO  VARCHAR(40),
    MICRO    VARCHAR(40),
    DELTA    BLOB SUB_TYPE 0 SEGMENT SIZE 80
);


/**** Primary Keys ****/

ALTER TABLE EVENTOS ADD PRIMARY KEY (CODEVENTO);

ALTER TABLE GRUPO1 ADD PRIMARY KEY (CODGRUPO);

ALTER TABLE GRUPO2 ADD PRIMARY KEY (CODGRUPO);

ALTER TABLE PESSOAS ADD PRIMARY KEY (CODPESSOA);

ALTER TABLE SISTEMA ADD PRIMARY KEY (ID);


/**** Foreign Keys ****/

ALTER TABLE PARTICIPACOES ADD FOREIGN KEY (CODPESSOA) 
REFERENCES PESSOAS (CODPESSOA) ON UPDATE CASCADE;

ALTER TABLE PARTICIPACOES ADD FOREIGN KEY (CODEVENTO) 
REFERENCES EVENTOS (CODEVENTO) ON UPDATE CASCADE;


/**** Indices ****/

CREATE INDEX IDX_EVENTOS_NOME ON EVENTOS (NOME);

CREATE INDEX IDX_GRUPO1_NOME ON GRUPO1 (DESCRICAO);

CREATE INDEX IDX_GRUPO2_NOME ON GRUPO2 (DESCRICAO);

CREATE INDEX IDX_PESSOAS_APELIDO ON PESSOAS (APELIDO);

CREATE INDEX IDX_PESSOAS_NOME ON PESSOAS (NOME);

CREATE INDEX IDX_PESSOAS_GRUPO1 ON PESSOAS (GRUPO1);

CREATE INDEX IDX_PESSOAS_GRUPO2 ON PESSOAS (GRUPO2);

CREATE DESCENDING INDEX LOGS_DATA ON LOGS (DATA);
