unit uConsPessoa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uFrmModeloCons, DBCtrls, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls,
  Menus, DB;

type
  TfrmConsPessoa = class(TfrmModeloCons)
    BitBtn1: TBitBtn;
    Label4: TLabel;
    DBText3: TDBText;
    Label3: TLabel;
    DBText1: TDBText;
    popRel: TPopupMenu;
    CRACHS1: TMenuItem;
    REGISTROSELECIONADO1: TMenuItem;
    PESQUISAATUAL1: TMenuItem;
    FICHACADASTRAL1: TMenuItem;
    REGISTROSELECIONADO2: TMenuItem;
    PESQUISAATUAL2: TMenuItem;
    procedure btCadastrarClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure btTransferirClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btPesquisaClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure bRelatorioClick(Sender: TObject);
    procedure REGISTROSELECIONADO1Click(Sender: TObject);
    procedure REGISTROSELECIONADO2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsPessoa: TfrmConsPessoa;

implementation

uses uDM, uCadEvento, uLib, uCadPessoa, uEventosPessoa, uRelCracha,
  uRelFichaCadastral;

{$R *.dfm}

procedure TfrmConsPessoa.BitBtn1Click(Sender: TObject);
begin
  inherited;
  if DBGrid1.DataSource.DataSet.IsEmpty then
  begin
    Alerta('Nenhum Participante Selecionado Para Visualizar os Eventos !');
    abort;
  end;

  AbreForm(TfrmEventosPessoa, frmEventosPessoa);
end;

procedure TfrmConsPessoa.bRelatorioClick(Sender: TObject);
begin
  inherited;
  popRel.Popup(
    //posio  esquerda
    bRelatorio.ClientOrigin.X,
    //posio do topo
    bRelatorio.ClientOrigin.Y - (popRel.Items.Count * 20));
end;

procedure TfrmConsPessoa.btAlterarClick(Sender: TObject);
begin
  inherited;
  AbreForm(TfrmCadPessoa, frmCadPessoa);
end;

procedure TfrmConsPessoa.btCadastrarClick(Sender: TObject);
begin
  inherited;
  with dm do Inserir(cdsPessoa);
  AbreForm(TfrmCadPessoa, frmCadPessoa);
end;

procedure TfrmConsPessoa.btExcluirClick(Sender: TObject);
begin
  inherited;
  with dm do Excluir(cdsPessoa, 'NOME');
end;

procedure TfrmConsPessoa.btPesquisaClick(Sender: TObject);
begin
  with dm.cdsPessoa do
  begin
    Close;
    Params.ParamByName('NOME').AsString := edtPesquisa.Text+'%';
    Open;
  end;
  inherited;
end;

procedure TfrmConsPessoa.btTransferirClick(Sender: TObject);
begin
  CodPessoa := dm.cdsPessoa.FieldByName('CODPESSOA').AsInteger;
  inherited;
end;

procedure TfrmConsPessoa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with dm.cdsPessoa do
  begin
    Params.ParamByName('NOME').Clear;
    Close;
  end;
  inherited;
end;

procedure TfrmConsPessoa.FormShow(Sender: TObject);
begin
  inherited;
  DBGrid1.Columns[6].Title.Caption := AnsiUpperCase(NOME_GRUPO1);
  DBGrid1.Columns[8].Title.Caption := AnsiUpperCase(NOME_GRUPO2);
end;

procedure TfrmConsPessoa.REGISTROSELECIONADO1Click(Sender: TObject);
var
  reg: TBookMark; //requer no uses a unit " DB "
begin
  inherited;
  //recupera a posio atual do cursor, para volta-la
  //aps a visualizao do relatrio
  reg := dm.cdsPessoa.GetBookmark;

  //se o menu que chamou foi o Pesquisa Atual
  //posiciona o cursor no primeiro registro
  if Sender = PESQUISAATUAL1 then
    dm.cdsPessoa.First;

  //cria o form. do relatrio
  frmRelCracha := TfrmRelCracha.Create(nil);
  try
    //se o menu que chamou foi o Registro selecinado
    if Sender = REGISTROSELECIONADO1 then
      //desvincula o QuickRep de seu DataSet
      frmRelCracha.QuickRep1.DataSet := nil;

    //executa a visualizao do Crach
    frmRelCracha.QuickRep1.Preview;
  finally
    //libera o form da memria
    frmRelCracha.Release;
  end;

  //se quem chamou foi o Pesquisa Atual
  //volta o cursor na posio antiga (antes do First)
  if Sender = PESQUISAATUAL1 then
  begin
    dm.cdsPessoa.GotoBookmark(reg);
    dm.cdsPessoa.FreeBookmark(reg);
  end;
end;

procedure TfrmConsPessoa.REGISTROSELECIONADO2Click(Sender: TObject);
var
  reg: TBookMark; //requer no uses a unit " DB "
begin
  inherited;
  //recupera a posio atual do cursor, para volta-la
  //aps a visualizao do relatrio
  reg := dm.cdsPessoa.GetBookmark;

  //se o menu que chamou foi o Pesquisa Atual
  //posiciona o cursor no primeiro registro
  if Sender = PESQUISAATUAL2 then
    dm.cdsPessoa.First;

  //cria o form. do relatrio
  frmRelFichaCadastral := TfrmRelFichaCadastral.Create(nil);
  try
    //se o menu que chamou foi o Registro selecinado
    if Sender = REGISTROSELECIONADO2 then
      //desvincula o QuickRep de seu DataSet
      frmRelFichaCadastral.QuickRep1.DataSet := nil;

    //executa a visualizao do Crach
    frmRelFichaCadastral.QuickRep1.Preview;
  finally
    //libera o form da memria
    frmRelFichaCadastral.Release;
  end;

  //se quem chamou foi o Pesquisa Atual
  //volta o cursor na posio antiga (antes do First)
  if Sender = PESQUISAATUAL2 then
  begin
    dm.cdsPessoa.GotoBookmark(reg);
    dm.cdsPessoa.FreeBookmark(reg);
  end;
end;

end.
