unit uCadastro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, DBActns, ActnList, StdCtrls,
  Buttons, ComCtrls, ImgList, Menus, SqlExpr, DB, AppEvnts, Grids, DBGrids;

type
  TfrmCadastro = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    ActionList1: TActionList;
    Novo: TDataSetInsert;
    Salvar: TDataSetPost;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    dsCadastro: TDataSource;
    Excluir: TAction;
    MainMenu1: TMainMenu;
    Arquivo1: TMenuItem;
    Relatrio1: TMenuItem;
    N1: TMenuItem;
    Sair1: TMenuItem;
    btnNovo: TBitBtn;
    btnExcluir: TBitBtn;
    btnSalvar: TBitBtn;
    TabSheet2: TTabSheet;
    DBGrid1: TDBGrid;
    dsPesquisa: TDataSource;
    procedure Sair1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure dsCadastroDataChange(Sender: TObject; Field: TField);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnSalvarClick(Sender: TObject);
    procedure TabSheet1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ExcluirUpdate(Sender: TObject);
    procedure ExcluirExecute(Sender: TObject);
    procedure btnNovoEnter(Sender: TObject);
    procedure NovoExecute(Sender: TObject);
  private
    { Private declarations }
  public
    procedure DisableEnableControls (Value : Boolean);
    function FieldsWrithe (DtSrc : TDataSource): Boolean;
  end;

var
  frmCadastro: TfrmCadastro;

implementation

{$R *.dfm}

procedure TfrmCadastro.Sair1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmCadastro.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  {: presisonamento da tecla ESC }
  if key = VK_Escape then
    Close;
end;

procedure TfrmCadastro.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   {: verifica se esta em modo de edio ou insero}
   if dsCadastro.State in [dsEdit,dsInsert] then
       case MessageDlg('Deseja salvar as alteraes realizados no Cadastro ?', mtConfirmation, [mbYes,mbNo,mbCancel], 0) of
         mrYes : begin
                 dsCadastro.DataSet.Post;
                 CanClose := True;
                 end;
         mrNo :  begin
                 dsCadastro.DataSet.Cancel;
                 CanClose := True;
                 end;
         mrCancel : CanClose := False;
       end;
end;

procedure TfrmCadastro.dsCadastroDataChange(Sender: TObject;
  Field: TField);
begin
   {: verifica o estado do DataSource para mostrar na barra }
   case dsCadastro.State of
     dsEdit: StatusBar1.Panels[1].Text := 'Alterando';
     dsInsert: StatusBar1.Panels[1].Text := 'Inserindo';
     dsBrowse: StatusBar1.Panels[1].Text := 'Navegando';
   end;
   DisableEnableControls(not dsCadastro.DataSet.IsEmpty);
   {: habilita os botes de acordo com o estado do DataSource }
   btnSalvar.Enabled := dsCadastro.State in [dsEdit, dsInsert];
   btnExcluir.Enabled := dsCadastro.State in [dsEdit];
end;

procedure TfrmCadastro.DisableEnableControls(Value: Boolean);
var
  i : integer;
begin
{: faz um lao em todos os componentes}
  for i := 0 to ComponentCount -1 do
  begin
    if (Components[i] is TCustomEdit) then
       (Components[i] as TCustomEdit).Enabled := Value;
    if (Components[i] is TBitBtn) then
       (Components[i] as TBitBtn).Enabled := Value;
  end;
  
  btnNovo.Enabled := True;
end;

procedure TfrmCadastro.FormKeyPress(Sender: TObject; var Key: Char);
begin
  {: troca ENTER por TAB}
  if key = #13 then
  begin
    Perform (CM_DialogKey, VK_TAB, 0);
    key:=#0;
  end
end;

procedure TfrmCadastro.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  {: limpa a StatusBar}
  StatusBar1.Panels[0].Text := '';
end;

function TfrmCadastro.FieldsWrithe(DtSrc: TDataSource): Boolean;
var
  i : integer;
{: verifica quais os campos que esto em branco no cadastro}
begin
  Result := True; {: assume que esto todos preenchidos}
  for i := 0 to DtSrc.DataSet.FieldCount - 1 do
    if DtSrc.DataSet.Fields[i].Required then
      if (DtSrc.DataSet.Fields[i].IsNull) Or
         (DtSrc.DataSet.Fields[i].AsString = '') then
      begin
        MessageDlg('Preencha o campo " '+ DtSrc.DataSet.Fields[i].DisplayLabel + '"', mtWarning,[mbOk], 0);
        Result := False;
        DtSrc.DataSet.Fields[i].FocusControl; {: coloca o foco no controle}
        Break;
      end;
end;

procedure TfrmCadastro.btnSalvarClick(Sender: TObject);
begin
  {: salvo as dados se os campos estiverem preenchidos}
  if FieldsWrithe(dsCadastro) And
    (dsCadastro.State in [dsEdit, dsInsert]) then
      dsCadastro.DataSet.Post;
end;

procedure TfrmCadastro.TabSheet1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  {: limpa a StatusBar}
  StatusBar1.Panels[0].Text := '';
end;

procedure TfrmCadastro.ExcluirUpdate(Sender: TObject);
begin
  Excluir.Enabled := (not dsCadastro.DataSet.IsEmpty) Or (dsCadastro.DataSet.RecordCount <=0);
end;

procedure TfrmCadastro.ExcluirExecute(Sender: TObject);
begin
  {: deleta se houver dados no DataSet }
  if (dsCadastro.DataSet.Active) And (dsCadastro.DataSet.RecordCount > 0) then
  begin
    if MessageDlg('Tem certeza que deseja excluir o registro ?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      dsCadastro.DataSet.Delete;
  end;
end;

procedure TfrmCadastro.btnNovoEnter(Sender: TObject);
begin
  StatusBar1.Panels[0].Text := (Sender as TControl).Hint;
end;

procedure TfrmCadastro.NovoExecute(Sender: TObject);
begin
  {: novo registro}
  dsCadastro.DataSet.Insert;
end;

end.
