unit uLib;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls,
  Dialogs, Forms, SqlExpr;

  procedure AbreForm(aClasseForm: TComponentClass; aForm: TForm);
  function RTrim(Texto: string): string;
  function LTrim(Texto: string): string;
  function DateValidate(const aData: string): boolean;
  function RemoveChar (const Ch: Char; const S: string): string;
  function RemoveAcento(Str: string): string;
  function BuscaTexto (Busca, Text: string): Boolean;
  function GeraSenha (aQuant: integer): string;
  function GeneratorID (aName: string; Connection: TSQLConnection; aInc: Boolean): integer;


implementation

{ Abrir formulrio }
procedure AbreForm(aClasseForm: TComponentClass; aForm: TForm);
begin
  Application.CreateForm(aClasseForm, aForm);
  try
    aForm.ShowModal;
  finally
    aForm.Free;
  end;
end;

{ Remove os espaos em branco  direita da string }
function RTrim(Texto: string): string;
var
  i: integer;
begin
  i := Length(Texto)+1;
  while True do
  begin
    Dec(i);
    if i <= 0 then
      break;
    if Texto[i] <> #32 then
      break;
  end;
  Result := Copy(Texto,1,i);
end;

{ Remove os espaos em branco  direita da string }
function LTrim(Texto: string): string;
var
  i: integer;
begin
  i := 0;
  while True do
  begin
    inc(i);
    if i > Length(Texto) then
      break;
    if Texto[i] <> #32 then
      break;
  end;
  Result := Copy(Texto,i,Length(Texto));
end;

{ Valida uma data }
function DateValidate(const aData: string): boolean;
begin
  try
    StrToDate(aData);
    Result := True;
  except
    Result := False;
  end;
end;

{ Remove caracter passado como parmetro }
function RemoveChar (const Ch: Char; const S: string): string;
var
  Posicao: integer;
begin
  Result := S;
  Posicao := Pos(Ch, Result);
  while Posicao > 0 do
  begin
    Delete(Result, Posicao, 1);
    Posicao := Pos(Ch, Result);
  end;
end;

{ Remove acentos da string passada como parmetro }
function RemoveAcento(Str: string): string;
const
  ComAcento = '';
  SemAcento = 'aaeouaoaeioucuAAEOUAOAEIOUCU';
var
  x: integer;
begin
  for x := 1 to Length(Str) do
    if Pos(Str[x], ComAcento) <> 0 then
      Str[x] := SemAcento[Pos(Str[x],ComAcento)];
  Result := Str;
end;

{ Pesquisa um caractere na string, retornando se achou }
function BuscaTexto (Busca, Text: string): Boolean;
begin
  Result := (Pos(Busca, Text) > 0);
end;

{ Gera caracteres aleatrios para uma senha }
function GeraSenha (aQuant: integer): string;
var
  i: integer;
const
  str = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
begin
  for i:= 1 to aQuant do
  begin
    Randomize;
    Result := Result + str[Random(Length(str))+1];
  end;
end;

{ Retorna o valor do Generator }
function GeneratorID (aName: string; Connection: TSQLConnection;
  aInc: Boolean): integer;
var
  Qry: TSQLQuery;
begin
  Qry := TSQLQuery.Create(nil);
  try
    Qry.SQLConnection := Connection;
    if aInc then
      Qry.SQL.Add('SELECT GEN_ID('+aName+', 1) FROM RDB$DATABASE')
	   else
      Qry.SQL.Add('SELECT GEN_ID('+aName+', 0) FROM RDB$DATABASE');
    Qry.Open;
    
    Result := Qry.Fields[0].AsInteger;
  finally
    FreeAndNil(Qry);
  end;
end;

end.
