unit UnitPrincipal;

interface

uses
  Windows, Classes, Graphics, Forms, Dialogs, StdCtrls, ExtDlgs, ExtCtrls,
  Controls;

type

  TFormPrincipal = class(TForm)
    ButtonSalvarTxt: TButton;
    ButtonCarregarImagem: TButton;
    ButtonConverterTexto: TButton;
    OpenPictureDialog1: TOpenPictureDialog;
    Panel1: TPanel;
    ImageBMP: TImage;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    MemoImagemTexto: TMemo;
    ButtonConverterImagem: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ButtonCarregarTxt: TButton;
    ButtonSalvarImagem: TButton;
    SavePictureDialog1: TSavePictureDialog;
    procedure ButtonCarregarImagemClick(Sender: TObject);
    procedure ButtonSalvarTxtClick(Sender: TObject);
    procedure ButtonConverterImagemClick(Sender: TObject);
    procedure ButtonConverterTextoClick(Sender: TObject);
    procedure ButtonCarregarTxtClick(Sender: TObject);
    procedure ButtonSalvarImagemClick(Sender: TObject);
  end;

var
  FormPrincipal: TFormPrincipal;

implementation

uses uOBJTextConverts;

{$R *.DFM}

procedure TFormPrincipal.ButtonCarregarImagemClick(Sender: TObject);
begin
  if not OpenPictureDialog1.Execute then
    Exit;

  ImageBMP.Picture.LoadFromFile(OpenPictureDialog1.FileName);
end;

procedure TFormPrincipal.ButtonSalvarTxtClick(Sender: TObject);
var
  f: TextFile;
begin
  if MemoImagemTexto.Lines.Count = 0 then
    Exit;

  if not SaveDialog1.Execute then
    Exit;

  AssignFile(f, SaveDialog1.FileName);
  ReWrite(f);
  try
    Write(f, MemoImagemTexto.Lines.Text);
  finally
    CloseFile(f);
  end;
end;

procedure TFormPrincipal.ButtonConverterImagemClick(Sender: TObject);
begin
  MemoImagemTexto.Lines.Text := TImageConverter.ImageToText(ImageBMP.Picture.Bitmap)
end;

procedure TFormPrincipal.ButtonConverterTextoClick(Sender: TObject);
begin
  TImageConverter.TextToImage(MemoImagemTexto.Lines.Text, ImageBMP.Picture.Bitmap);
end;

procedure TFormPrincipal.ButtonCarregarTxtClick(Sender: TObject);
begin
  if not OpenDialog1.Execute then
    Exit;

  MemoImagemTexto.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TFormPrincipal.ButtonSalvarImagemClick(Sender: TObject);
begin
  if not SavePictureDialog1.Execute then
    Exit;

  ImageBMP.Picture.Bitmap.SaveToFile(SavePictureDialog1.FileName);
end;

end.

