unit uQRCheckBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, QuickRpt;

const
  _BMP_CHECKED = '{'+
    '424D4E0100000000000076000000280000001200000012000000010004000000'+
    '0000D80000000000000000000000100000000000000000000000000080000080'+
    '00000080800080000000800080008080000080808000C0C0C0000000FF0000FF'+
    '000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00FFFFFFFFFFFFFFFFFF00'+
    '0000F0000000000000000F000000F0000000000000000F000000F00FFFFFFFFF'+
    'FFF00F000000F00FFFFFFFFFFFF00F000000F00FFF000FFFFFF00F000000F00F'+
    'FF000FFFFFF00F000000F00FF00000FFFFF00F000000F00FF00F000FFFF00F00'+
    '0000F00F000FF00FFFF00F000000F00FFFFFFF00FFF00F000000F00FFFFFFFF0'+
    '0FF00F000000F00FFFFFFFFF0FF00F000000F00FFFFFFFFFF0F00F000000F00F'+
    'FFFFFFFFFF000F000000F0000000000000000F000000F0000000000000000F00'+
    '0000FFFFFFFFFFFFFFFFF0000000}';

  _BMP_UNCHECKED = '{'+
    '424D4E0100000000000076000000280000001200000012000000010004000000'+
    '0000D8000000C40E0000C40E0000100000000000000000000000000080000080'+
    '00000080800080000000800080008080000080808000C0C0C0000000FF0000F0'+
    '0000000F0F00FF000000FF00FF00FFFF0000FFFFFF00FFFFFFFFFFFFFFFFFF00'+
    '0000F0000000000000000F000000F0000000000000000F000000F00FFFFFFFFF'+
    'FFF00F000000F00FFFFFFFFFFFF00F000000F00FFFFFFFFFFFF00F000000F00F'+
    'FFFFFFFFFFF00F000000F00FFFFFFFFFFFF00F000000F00FFFFFFFFFFFF00F00'+
    '0000F00FFFFFFFFFFFF00F000000F00FFFFFFFFFFFF00F000000F00FFFFFFFFF'+
    'FFF00F000000F00FFFFFFFFFFFF00F000000F00FFFFFFFFFFFF00F000000F00F'+
    'FFFFFFFFFFF00F000000F0000000000000000F000000F0000000000000000F00'+
    '0000FFFFFFFFFFFFFFFFFF000000}';

type
  TQRCheckBox = class(TQRPrintable)
  private
    FCheckBox: TCheckBox;
    FWordWrap: Boolean;
//    FBMPChecked: TBitMap;
//    FBMPUnchecked: TBitmap;

    FBitMap: TBitMap; //Acrescentada a varivel privada que ir armazenar a imagem Checked ou UnChecked
    function GetChecked: Boolean;
    procedure SetChecked(const Value: Boolean);
//    procedure SetBMPChecked(const Value: TBitMap);
//    procedure SetBMPUnchecked(const Value: TBitmap);
  protected
    procedure Print(OfsX, OfsY : integer); override;
    procedure CMTextChanged(var Msg: TMessage); message CM_TEXTCHANGED;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight : integer); override;
  published
//    property BMPChecked: TBitMap read FBMPChecked write SetBMPChecked;
//    property BMPUnchecked: TBitmap read FBMPUnchecked write SetBMPUnchecked;
    property Caption;
    property Checked: Boolean read GetChecked write SetChecked;
    property Font;
    property WordWrap: Boolean read FWordWrap write FWordWrap;
  end;

procedure Register;

implementation

uses uOBJTextConverts;

{ TQRCheckBox }

procedure Register;
begin
  RegisterComponents('QuickRepComps', [TQRCheckBox]);
end;

constructor TQRCheckBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FCheckBox := TCheckBox.Create(Self);
  FCheckBox.Parent := Self;

//  FBMPChecked := TBitmap.Create;
//  FBMPUnchecked := TBitmap.Create;
  FBitMap := TBitmap.Create;
end;

destructor TQRCheckBox.Destroy;
begin
// FCheckBox.Free; {No destruir o FCheckBox manualmente,
                   { pois ele ser destrudo automaticamente,
                     junto com o seu Owner.}

//  FreeAndNil(FBMPChecked);
//  FreeAndNil(FBMPUnchecked);
  FBitMap.Free;

  inherited;
end;

function TQRCheckBox.GetChecked: Boolean;
begin
  {Retornamos o valor Checked de FCheckBox}
  Result := FCheckBox.Checked;
end;

procedure TQRCheckBox.Print(OfsX, OfsY: integer);
var
  rcImage, rcText: TRect;
//  BitMap: TBitMap;
  TopOfImage: Extended;
begin

  {Verifica se o relatrio est pronto para imprimir}
  if ParentReport.FinalPass and IsEnabled then
  begin
    with QRPrinter do
    begin
      with Canvas do
      begin
        Font := FCheckBox.Font;

        {Clculo do incio (topo) onde a imagem ser exibida}
        TopOfImage := (OfsY + Size.Top + Size.Height /2) -20;

        {Clculo do permetro para exibio da imagem}
        rcImage := Rect(XPos(OfsX + Size.Left), YPos(TopOfImage),
          XPos(OfsX + Size.Left +40), YPos(TopOfImage +40));

        {clculo do permetro para exibio do texto - propriedade Caption}
        rcText := Rect(XPos(OfsX + Size.Left + 50), YPos(OfsY + Size.Top),
          XPos(OfsX + Size.Left + Size.Width), YPos(OfsY + Size.Top + Size.Height));

(*        {Define qual das imagens ser exibida, de acordo com a propriedade Checked}
        if FCheckBox.Checked then
          BitMap := BMPChecked
        else
          BitMap := BMPUnchecked;
*)
        {Define qual das imagens ser exibida, de acordo com a propriedade Checked}
        if FCheckBox.Checked then
          TImageConverter.TextToImage(_BMP_CHECKED, FBitMap)
        else
          TImageConverter.TextToImage(_BMP_UNCHECKED, FBitMap);

(*
        {Se nenhuma imagem foi definida, ento exibe somente o texto}
        if BitMap.Empty then
        begin
          if FCheckBox.Checked then
            Windows.DrawText(Handle, PChar('(X) '+ Caption), -1, rcText, DT_SINGLELINE or DT_VCENTER)
          else
            Windows.DrawText(Handle, PChar('( ) '+ Caption), -1, rcText, DT_SINGLELINE or DT_VCENTER);
          Exit;
        end;

*)
        {Controle a quebra de linha de acordo com a propriedade WordWrap}
        if FWordWrap then
          Windows.DrawText(Handle, PChar(Caption), -1, rcText, DT_VCENTER or DT_WORDBREAK)
        else
          Windows.DrawText(Handle, PChar(Caption), -1, rcText, DT_SINGLELINE or DT_VCENTER);

        {Desenha a imagem escolhida, dentro do permetro calculado}
        StretchDraw(rcImage, FBitMap);
      end;
    end;
  end;

  inherited;
end;

procedure TQRCheckBox.SetBounds(ALeft, ATop, AWidth,
  AHeight: integer);
begin
  inherited;

  {Quando o tamanho do QRCheckBox  alterado, chamamos o mtodo
   SetBounds do FCheckBox para se ajustar ao novo tamanho
  }
  if Assigned(FCheckBox) then
    FCheckBox.SetBounds(1, 1, AWidth -3, AHeight -3);
end;

procedure TQRCheckBox.SetChecked(const Value: Boolean);
begin
  {Quando a propriedade Checked  alterada, alteramos a propriedade Checked
   do FCheckBox.
  }
  FCheckBox.Checked := Value;
end;

procedure TQRCheckBox.CMTextChanged(var Msg: TMessage);
begin
  FCheckBox.Caption := Self.Caption; //Self  TQRCheckBox

  inherited;
end;

(*procedure TQRCheckBox.SetBMPChecked(const Value: TBitMap);
begin
  FBMPChecked.Assign(Value);
end;

procedure TQRCheckBox.SetBMPUnchecked(const Value: TBitmap);
begin
  FBMPUnchecked.Assign(Value);
end;
*)
end.
